/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.devices.BlockCharcoalForge;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TECharcoalForge;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockCharcoalPile
extends Block
implements ILightableBlock {
    public static final Material CHARCOAL_MATERIAL = new Material(MapColor.field_151650_B);
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"type", (int)1, (int)8);
    private static final AxisAlignedBB[] PILE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockCharcoalPile() {
        super(CHARCOAL_MATERIAL);
        this.func_149672_a(TFCSounds.CHARCOAL_PILE);
        this.setHarvestLevel("shovel", 0);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 8;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(meta + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) - 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 8;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PILE_AABB[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN || (Integer)state.func_177229_b((IProperty)LAYERS) == 8 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return PILE_AABB[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public boolean func_149662_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 8;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            IBlockState stateUnder = worldIn.func_180495_p(pos.func_177977_b());
            if (stateUnder.func_177230_c() instanceof BlockCharcoalPile) {
                int layersAt = (Integer)state.func_177229_b((IProperty)LAYERS);
                int layersUnder = (Integer)stateUnder.func_177229_b((IProperty)LAYERS);
                if (layersUnder < 8) {
                    if (layersUnder + layersAt <= 8) {
                        worldIn.func_175656_a(pos.func_177977_b(), stateUnder.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(layersAt + layersUnder)));
                        worldIn.func_175698_g(pos);
                    } else {
                        worldIn.func_175656_a(pos.func_177977_b(), stateUnder.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(8)));
                        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(layersAt + layersUnder - 8)));
                    }
                }
                return;
            }
            if (!stateUnder.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP)) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151044_h;
    }

    public int func_180651_a(IBlockState state) {
        return 1;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if ((Integer)state.func_177229_b((IProperty)LAYERS) >= 7 && BlockCharcoalForge.isValid(world, pos) && ItemFireStarter.onIgnition(stack)) {
            if (!world.field_72995_K) {
                TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                world.func_175656_a(pos, BlocksTFC.CHARCOAL_FORGE.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                TECharcoalForge te = Helpers.getTE((IBlockAccess)world, pos, TECharcoalForge.class);
                if (te != null) {
                    te.onCreate();
                }
            }
            return true;
        }
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAYERS});
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        if (player.func_184812_l_()) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        if (!world.field_72995_K) {
            int layers = (Integer)state.func_177229_b((IProperty)LAYERS);
            if (layers == 1) {
                world.func_175698_g(pos);
            } else {
                world.func_175656_a(pos, state.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(layers - 1)));
            }
        }
        return true;
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Items.field_151044_h, 1, 1);
    }
}

