/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.blocks.BlockTorchTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.TEPowderKeg;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockPowderKeg
extends Block
implements IItemSize,
ILightableBlock {
    public static final PropertyBool SEALED = PropertyBool.func_177716_a((String)"sealed");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public static void togglePowderKegSeal(World world, BlockPos pos) {
        TEPowderKeg tile = Helpers.getTE((IBlockAccess)world, pos, TEPowderKeg.class);
        if (tile != null) {
            IBlockState state;
            boolean previousSealed = (Boolean)(state = world.func_180495_p(pos)).func_177229_b((IProperty)SEALED);
            world.func_175656_a(pos, state.func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            tile.setSealed(!previousSealed);
        }
    }

    public BlockPowderKeg() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(false)));
    }

    public void trigger(World worldIn, BlockPos pos, IBlockState state, @Nullable EntityLivingBase igniter) {
        TEPowderKeg te;
        if (!worldIn.field_72995_K && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPowderKeg.class)) != null && ((Boolean)state.func_177229_b((IProperty)SEALED)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && te.getStrength() > 0) {
            worldIn.func_175656_a(pos, state);
            te.setLit(true);
            te.setIgniter(igniter);
        }
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return stack.func_77978_p() == null ? Size.VERY_LARGE : Size.HUGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Override
    public boolean canStack(@Nonnull ItemStack stack) {
        return stack.func_77978_p() == null;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SEALED) != false ? 1 : 0;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rng) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        TEPowderKeg te = Helpers.getTE((IBlockAccess)world, pos, TEPowderKeg.class);
        if (te != null) {
            int fuse = te.getFuse();
            if (rng.nextInt(6) == 0 && fuse > 20) {
                world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, rng.nextFloat() * 1.3f + 0.3f / (float)fuse, false);
            }
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.625, (double)pos.func_177984_a().func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.375, 0.0, 1.0 + 1.0 / (double)fuse, 0.0, new int[0]);
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.trigger(worldIn, pos, state, null);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TEPowderKeg tile;
        if (world.func_175640_z(pos) || world.func_180495_p(fromPos).func_185904_a() == Material.field_151581_o) {
            this.func_176206_d(world, pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && pos.func_177984_a().equals((Object)fromPos) && world.func_180495_p(fromPos).func_185904_a() == Material.field_151586_h && (tile = Helpers.getTE((IBlockAccess)world, pos, TEPowderKeg.class)) != null) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            tile.setLit(false);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (worldIn.func_175640_z(pos)) {
            this.func_176206_d(worldIn, pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEPowderKeg tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEPowderKeg.class);
        if (tile != null && !tile.isLit()) {
            tile.onBreakBlock(worldIn, pos, state);
            super.func_180663_b(worldIn, pos, state);
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.canStay((IBlockAccess)world, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            TEPowderKeg te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPowderKeg.class);
            if (te != null) {
                if (heldItem.func_190926_b() && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
                    te.setLit(false);
                } else if (heldItem.func_190926_b() && playerIn.func_70093_af()) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 0.85f);
                    BlockPowderKeg.togglePowderKegSeal(worldIn, pos);
                } else if (((Boolean)state.func_177229_b((IProperty)SEALED)).booleanValue() && BlockTorchTFC.canLight(heldItem)) {
                    this.trigger(worldIn, pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)playerIn);
                    if (heldItem.func_77973_b().func_77645_m()) {
                        heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                    } else if (!playerIn.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                } else {
                    TFCGuiHandler.openGui(worldIn, pos, playerIn, TFCGuiHandler.Type.POWDERKEG);
                }
            }
        }
        return true;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EntityArrow entityarrow;
        if (!worldIn.field_72995_K && entityIn instanceof EntityArrow && (entityarrow = (EntityArrow)entityIn).func_70027_ad()) {
            this.trigger(worldIn, pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), entityarrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.field_70250_c : null);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TEPowderKeg te;
        NBTTagCompound nbt;
        if (!worldIn.field_72995_K && (nbt = stack.func_77978_p()) != null && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPowderKeg.class)) != null) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(true)));
            te.readFromItemTag(nbt);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SEALED, LIT});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 14 : 0;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEPowderKeg();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (!((Boolean)state.func_177229_b((IProperty)SEALED)).booleanValue()) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void onBlockExploded(World worldIn, BlockPos pos, Explosion explosionIn) {
        TEPowderKeg te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPowderKeg.class);
        if (!worldIn.field_72995_K && te != null && te.getStrength() > 0) {
            this.trigger(worldIn, pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), null);
        } else {
            super.onBlockExploded(worldIn, pos, explosionIn);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TEPowderKeg tile = Helpers.getTE((IBlockAccess)world, pos, TEPowderKeg.class);
        if (tile != null) {
            return tile.getItemStack(state);
        }
        return new ItemStack(state.func_177230_c());
    }

    private boolean canStay(IBlockAccess world, BlockPos pos) {
        boolean solid = world.func_180495_p(pos.func_177977_b()).func_193401_d(world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
        return solid || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockPowderKeg;
    }
}

