/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class BlockTorchTFC
extends BlockTorch
implements IItemSize,
ILightableBlock {
    public static boolean canLight(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || ItemFireStarter.canIgnite(stack);
    }

    public BlockTorchTFC() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185848_a);
        OreDictionaryHelper.register((Block)this, "torch");
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.LIGHT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta % 6).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta >= 6));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 6 : 0) + super.func_176201_c(state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176596_a, LIT});
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TETickCounter te = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (te != null && !worldIn.field_72995_K && te.getTicksSinceUpdate() > (long)ConfigTFC.General.OVERRIDES.torchTime && ConfigTFC.General.OVERRIDES.torchTime > 0) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
            te.resetCounter();
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? Item.func_150898_a((Block)Blocks.field_150478_aa) : Items.field_151055_y;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                if (OreDictionaryHelper.doesStackMatchOre(stack, "stickWood")) {
                    stack.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)new ItemStack(Blocks.field_150478_aa));
                }
            } else if (BlockTorchTFC.canLight(stack)) {
                TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)playerIn, state.func_177230_c());
                worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                TETickCounter tile = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
                if (tile != null) {
                    tile.resetCounter();
                }
            }
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TETickCounter tile = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (tile != null) {
            tile.resetCounter();
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.getLightValue(state, world, pos) : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TETickCounter();
    }
}

