/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropDead;
import net.dries007.tfc.objects.blocks.stone.BlockFarmlandTFC;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.objects.te.TECropBase;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.agriculture.Crop;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.util.skills.SimpleSkill;
import net.dries007.tfc.util.skills.SkillType;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

@ParametersAreNonnullByDefault
public abstract class BlockCropTFC
extends BlockBush {
    public static final PropertyInteger STAGE_8 = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)7);
    public static final PropertyInteger STAGE_7 = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)6);
    public static final PropertyInteger STAGE_6 = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)5);
    public static final PropertyInteger STAGE_5 = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)4);
    public static final HashMap<Integer, PropertyInteger> STAGE_MAP = new HashMap();
    public static final PropertyBool WILD = PropertyBool.func_177716_a((String)"wild");
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.375, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.625, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.875, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875)};
    private static final int META_WILD = 8;
    private static final int META_GROWTH = 7;
    private static final Map<ICrop, BlockCropTFC> MAP = new HashMap<ICrop, BlockCropTFC>();
    private final ICrop crop;

    public static BlockCropTFC get(ICrop crop) {
        return MAP.get(crop);
    }

    public static Set<ICrop> getCrops() {
        return MAP.keySet();
    }

    static PropertyInteger getStagePropertyForCrop(ICrop crop) {
        return STAGE_MAP.get(crop.getMaxStage() + 1);
    }

    public BlockCropTFC(ICrop crop) {
        super(Material.field_151585_k);
        this.crop = crop;
        if (MAP.put(crop, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.6f);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WILD, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)this.getStageProperty(), (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getStageProperty()) + ((Boolean)state.func_177229_b((IProperty)WILD) != false ? 8 : 0);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(worldIn, pos, state, random);
        this.checkGrowth(worldIn, pos, state, random);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TECropBase tile = Helpers.getTE((IBlockAccess)worldIn, pos, TECropBase.class);
        if (tile != null) {
            tile.resetCounter();
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getStageProperty(), WILD});
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TECropBase();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        SimpleSkill skill;
        EntityPlayer player = (EntityPlayer)this.harvesters.get();
        ItemStack seedStack = new ItemStack((Item)ItemSeedsTFC.get(this.crop));
        ItemStack foodStack = this.crop.getFoodDrop((Integer)state.func_177229_b((IProperty)this.getStageProperty()));
        if (player != null && (skill = CapabilityPlayerData.getSkill(player, SkillType.AGRICULTURE)) != null && !foodStack.func_190926_b()) {
            foodStack.func_190920_e(1 + Crop.getSkillFoodBonus(skill, RANDOM));
            seedStack.func_190920_e(1 + Crop.getSkillSeedBonus(skill, RANDOM));
            skill.add(0.04f);
        }
        if (!foodStack.func_190926_b()) {
            drops.add((Object)foodStack);
        }
        if (!seedStack.func_190926_b()) {
            drops.add((Object)seedStack);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ItemSeedsTFC.get(this.crop));
    }

    @Nonnull
    public ICrop getCrop() {
        return this.crop;
    }

    public void checkGrowth(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TECropBase te;
        if (!worldIn.field_72995_K && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TECropBase.class)) != null) {
            IBlockState stateFarmland = worldIn.func_180495_p(pos.func_177977_b());
            if (!((Boolean)state.func_177229_b((IProperty)WILD)).booleanValue() && (!worldIn.func_175678_i(pos) || stateFarmland.func_177230_c() instanceof BlockFarmlandTFC && (Integer)stateFarmland.func_177229_b((IProperty)BlockFarmlandTFC.MOISTURE) < 3)) {
                te.resetCounter();
                return;
            }
            long growthTicks = (long)((double)this.crop.getGrowthTicks() * ConfigTFC.General.FOOD.cropGrowthTimeModifier);
            int fullGrownStages = 0;
            while (te.getTicksSinceUpdate() > growthTicks) {
                te.reduceCounter(growthTicks);
                float temp = ClimateTFC.getActualTemp(worldIn, pos, -te.getTicksSinceUpdate());
                float rainfall = ChunkDataTFC.getRainfall(worldIn, pos);
                if (this.crop.isValidForGrowth(temp, rainfall)) {
                    this.grow(worldIn, pos, state, random);
                    state = worldIn.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof BlockCropTFC) || ((Boolean)state.func_177229_b((IProperty)WILD)).booleanValue() || ((Integer)state.func_177229_b((IProperty)this.getStageProperty())).intValue() != this.crop.getMaxStage() || ++fullGrownStages <= 2) continue;
                    this.die(worldIn, pos, state, random);
                    return;
                }
                if (this.crop.isValidConditions(temp, rainfall)) continue;
                this.die(worldIn, pos, state, random);
                return;
            }
        }
    }

    public abstract void grow(World var1, BlockPos var2, IBlockState var3, Random var4);

    public void die(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (ConfigTFC.General.FOOD.enableCropDeath) {
            worldIn.func_175656_a(pos, BlockCropDead.get(this.crop).func_176223_P().func_177226_a((IProperty)BlockCropDead.MATURE, (Comparable)Boolean.valueOf(((Integer)state.func_177229_b((IProperty)this.getStageProperty())).intValue() == this.crop.getMaxStage())));
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.getStageProperty())];
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public abstract PropertyInteger getStageProperty();

    static {
        STAGE_MAP.put(5, STAGE_5);
        STAGE_MAP.put(6, STAGE_6);
        STAGE_MAP.put(7, STAGE_7);
        STAGE_MAP.put(8, STAGE_8);
    }
}

