/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.objects.blocks.BlockPlacedItem;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TEPitKiln;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockPitKiln
extends Block
implements ILightableBlock {
    public static final PropertyBool FULL = PropertyBool.func_177716_a((String)"full");
    private static final AxisAlignedBB[] AABB_LEVELS = new AxisAlignedBB[]{BlockPlacedItem.PLACED_ITEM_AABB, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), field_185505_j};

    public BlockPitKiln() {
        super(Material.field_151594_q);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FULL, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_185481_k(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FULL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)FULL, (Comparable)Boolean.valueOf((meta & 2) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)FULL) != false ? 2 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TEPitKiln tile = Helpers.getTE(source, pos, TEPitKiln.class);
        if (tile != null) {
            int height = tile.getStrawCount();
            if (tile.getLogCount() > 4) {
                height = 10;
            } else if (tile.getLogCount() > 0) {
                height = 9;
            }
            return AABB_LEVELS[height];
        }
        return BlockPlacedItem.PLACED_ITEM_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TEPitKiln te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPitKiln.class);
        if (te != null) {
            if (blockIn == Blocks.field_150480_ab) {
                te.tryLight();
            }
            if (!worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                if (te.isLit()) {
                    te.emptyFuelContents();
                }
                worldIn.func_175655_b(pos, true);
            }
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEPitKiln te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPitKiln.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TEPitKiln te = Helpers.getTE((IBlockAccess)worldIn, pos, TEPitKiln.class);
        if (te != null) {
            if (ItemFireStarter.canIgnite(playerIn.func_184586_b(hand))) {
                return false;
            }
            return te.onRightClick(playerIn, playerIn.func_184586_b(hand), (double)hitX < 0.5, (double)hitZ < 0.5);
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FULL, LIT});
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_185899_b(world, pos).func_177229_b((IProperty)FULL);
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_185899_b(world, pos).func_177229_b((IProperty)LIT);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return (Boolean)world.func_180495_p(pos).func_185899_b(world, pos).func_177229_b((IProperty)LIT) != false ? 120 : 0;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return (Boolean)world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)LIT);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEPitKiln();
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false && (entity == null || !entity.func_70045_F()) ? PathNodeType.DAMAGE_FIRE : null;
    }
}

