/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.metal;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlockTorchTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.TELamp;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockMetalLamp
extends Block
implements ILightableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.VERTICAL);
    private static final Map<Metal, BlockMetalLamp> MAP = new HashMap<Metal, BlockMetalLamp>();
    private static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.5, 0.6875);
    private static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private final Metal metal;

    public static BlockMetalLamp get(Metal metal) {
        return MAP.get((Object)metal);
    }

    public static ItemStack get(Metal metal, int amount) {
        return new ItemStack((Block)MAP.get((Object)metal), amount);
    }

    public BlockMetalLamp(Metal metal) {
        super(Material.field_151591_t);
        this.metal = metal;
        if (MAP.put(metal, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public Metal getMetal() {
        return this.metal;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta % 2))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta >= 2));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 2 : 0);
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                return AABB_UP;
            }
        }
        return AABB_DOWN;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TELamp tel;
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && ConfigTFC.Devices.LAMP.burnRate > 0.0 && (tel = Helpers.getTE((IBlockAccess)worldIn, pos, TELamp.class)) != null) {
            this.checkFuel(worldIn, pos, state, tel);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TELamp tel = Helpers.getTE((IBlockAccess)worldIn, pos, TELamp.class);
        if (tel != null) {
            if (worldIn.func_175640_z(pos) && !tel.isPowered()) {
                this.lightWithFuel(worldIn, pos, state, tel);
                tel.setPowered(true);
            } else if (!worldIn.func_175640_z(pos) && tel.isPowered() && !this.checkFuel(worldIn, pos, state, tel)) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
                tel.setPowered(false);
                tel.resetCounter();
            }
        }
        if (!this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            worldIn.func_175655_b(pos, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TELamp tel = Helpers.getTE((IBlockAccess)worldIn, pos, TELamp.class);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K && tel != null) {
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                if (!this.checkFuel(worldIn, pos, state, tel)) {
                    worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
                    tel.resetCounter();
                }
            } else if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandler fluidHandler = (IFluidHandler)tel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)fluidHandler);
                    tel.func_70296_d();
                }
            } else if (BlockTorchTFC.canLight(stack) && this.lightWithFuel(worldIn, pos, state, tel)) {
                TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)playerIn, state.func_177230_c());
            }
        }
        return true;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        if (this.canPlaceAt(worldIn, pos, EnumFacing.UP)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        }
        if (this.canPlaceAt(worldIn, pos, EnumFacing.DOWN)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
        }
        return this.func_176223_P();
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77978_p() != null) {
            TELamp tile = Helpers.getTE((IBlockAccess)worldIn, pos, TELamp.class);
            if (tile != null) {
                tile.resetCounter();
                tile.loadFromItemStack(stack);
            }
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TELamp();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TELamp tile = Helpers.getTE(world, pos, TELamp.class);
        if (tile != null) {
            if (tile.getFuel() == 0) {
                super.getDrops(drops, world, pos, state, fortune);
            } else {
                drops.add((Object)tile.getItemStack(tile, state));
            }
        }
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TELamp tile = Helpers.getTE((IBlockAccess)world, pos, TELamp.class);
        if (tile != null) {
            return tile.getItemStack(tile, state);
        }
        return new ItemStack(state.func_177230_c());
    }

    private boolean lightWithFuel(World worldIn, BlockPos pos, IBlockState state, TELamp tel) {
        if (tel.getFuel() > 0) {
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
            tel.resetCounter();
            return true;
        }
        return false;
    }

    private boolean checkFuel(World worldIn, BlockPos pos, IBlockState state, TELamp tel) {
        long ticks;
        double usage;
        IFluidHandler fluidHandler = (IFluidHandler)tel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        boolean ranOut = false;
        if (!worldIn.field_72995_K && fluidHandler != null && (usage = ConfigTFC.Devices.LAMP.burnRate * (double)(ticks = tel.getTicksSinceUpdate()) / 1000.0) >= 1.0) {
            FluidStack used = fluidHandler.drain((int)usage, true);
            if (used == null || used.amount < (int)usage) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
                ranOut = true;
            }
            tel.resetCounter();
        }
        return ranOut;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        if (!FACING.func_177700_c().contains(facing)) {
            return false;
        }
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockMetalLamp.func_193382_c((Block)block) && blockfaceshape == BlockFaceShape.SOLID;
        }
        return facing == EnumFacing.DOWN && blockfaceshape == BlockFaceShape.SOLID;
    }
}

