/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockTallWaterPlantTFC;
import net.dries007.tfc.objects.blocks.property.ITallPlant;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockEmergentTallWaterPlantTFC
extends BlockTallWaterPlantTFC
implements ITallPlant {
    private static final Map<Plant, BlockEmergentTallWaterPlantTFC> MAP = new HashMap<Plant, BlockEmergentTallWaterPlantTFC>();

    public static BlockEmergentTallWaterPlantTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockEmergentTallWaterPlantTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState water = this.plant.getWaterType();
        int i = 1;
        while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
            ++i;
        }
        if (water == ChunkGenTFC.SALT_WATER) {
            return i < this.plant.getMaxHeight() && (worldIn.func_175623_d(pos.func_177984_a()) || BlocksTFC.isSaltWater(worldIn.func_180495_p(pos.func_177984_a()))) && this.func_180671_f(worldIn, pos.func_177984_a(), state);
        }
        return i < this.plant.getMaxHeight() && (worldIn.func_175623_d(pos.func_177984_a()) || BlocksTFC.isFreshWater(worldIn.func_180495_p(pos.func_177984_a()))) && this.func_180671_f(worldIn, pos.func_177984_a(), state);
    }

    @Override
    public void shrink(World worldIn, BlockPos pos) {
        boolean flag = false;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!BlocksTFC.isWater(worldIn.func_180495_p(pos.func_177972_a(enumfacing)))) continue;
            flag = true;
        }
        if (flag) {
            worldIn.func_175656_a(pos, this.plant.getWaterType());
        } else {
            worldIn.func_175698_g(pos);
        }
        worldIn.func_180495_p(pos).func_189546_a(worldIn, pos.func_177977_b(), (Block)this, pos);
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (this.plant.getWaterType() == ChunkGenTFC.SALT_WATER) {
            return (soil.func_177230_c() == this || BlocksTFC.isSaltWater(worldIn.func_180495_p(pos))) && this.func_185514_i(soil);
        }
        return (soil.func_177230_c() == this || BlocksTFC.isFreshWater(worldIn.func_180495_p(pos))) && this.func_185514_i(soil);
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        boolean flag = false;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!BlocksTFC.isWater(world.func_180495_p(pos.func_177972_a(enumfacing)))) continue;
            flag = true;
        }
        if (flag) {
            return world.func_180501_a(pos, this.plant.getWaterType(), world.field_72995_K ? 11 : 3);
        }
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    @Override
    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            boolean flag = false;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                if (!BlocksTFC.isWater(worldIn.func_180495_p(pos.func_177972_a(enumfacing)))) continue;
                flag = true;
            }
            this.func_176226_b(worldIn, pos, state, 0);
            if (flag) {
                worldIn.func_175656_a(pos, this.plant.getWaterType());
            } else {
                worldIn.func_175698_g(pos);
            }
        }
    }
}

