/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockEpiphyteTFC
extends BlockPlantTFC {
    private static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final AxisAlignedBB PLANT_UP_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB PLANT_DOWN_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB PLANT_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB PLANT_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
    private static final AxisAlignedBB PLANT_WEST_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB PLANT_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
    private static final Map<Plant, BlockEpiphyteTFC> MAP = new HashMap<Plant, BlockEpiphyteTFC>();

    public static BlockEpiphyteTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockEpiphyteTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)DAYPERIOD, (Comparable)Integer.valueOf(this.getDayPeriod())).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())));
        this.func_176475_e(world, pos, state);
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return worldIn.func_180495_p(pos).func_177230_c() != this;
        }
        return false;
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return false;
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return PLANT_EAST_AABB;
            }
            case WEST: {
                return PLANT_WEST_AABB;
            }
            case SOUTH: {
                return PLANT_SOUTH_AABB;
            }
            case NORTH: {
                return PLANT_NORTH_AABB;
            }
            case DOWN: {
                return PLANT_DOWN_AABB;
            }
        }
        return PLANT_UP_AABB;
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, this.growthStageProperty, DAYPERIOD, AGE});
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public IBlockState getStateForWorldGen(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    private void onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (this.checkForDrop(worldIn, pos, state)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            EnumFacing.Axis axis = facing.func_176740_k();
            BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
            boolean flag = false;
            if (axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, facing) != BlockFaceShape.SOLID) {
                flag = true;
            } else if (axis.func_176720_b() && !this.canPlaceOn(worldIn, blockpos)) {
                flag = true;
            }
            if (flag) {
                worldIn.func_175655_b(pos, true);
            }
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176475_e(worldIn, pos, state);
        }
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLogTFC;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        return this.canPlaceOn(worldIn, blockpos) && blockfaceshape == BlockFaceShape.SOLID;
    }
}

