/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockWaterPlantTFC;
import net.dries007.tfc.objects.blocks.property.ITallPlant;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class BlockTallWaterPlantTFC
extends BlockWaterPlantTFC
implements IGrowable,
ITallPlant {
    private static final PropertyEnum<ITallPlant.EnumBlockPart> PART = PropertyEnum.func_177709_a((String)"part", ITallPlant.EnumBlockPart.class);
    private static final Map<Plant, BlockTallWaterPlantTFC> MAP = new HashMap<Plant, BlockTallWaterPlantTFC>();

    public static BlockTallWaterPlantTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockTallWaterPlantTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState water = this.plant.getWaterType();
        int i = 1;
        while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
            ++i;
        }
        if (water == ChunkGenTFC.SALT_WATER) {
            return i < this.plant.getMaxHeight() && BlocksTFC.isSaltWater(worldIn.func_180495_p(pos.func_177984_a())) && this.func_180671_f(worldIn, pos.func_177984_a(), state);
        }
        return i < this.plant.getMaxHeight() && BlocksTFC.isFreshWater(worldIn.func_180495_p(pos.func_177984_a())) && this.func_180671_f(worldIn, pos.func_177984_a(), state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
        IBlockState iblockstate = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.growthStageProperty, (Comparable)Integer.valueOf(this.plant.getStageForMonth())).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos)));
        worldIn.func_175656_a(pos, iblockstate);
        iblockstate.func_189546_a(worldIn, pos.func_177984_a(), (Block)this, pos);
    }

    public void shrink(World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, this.plant.getWaterType());
        worldIn.func_180495_p(pos).func_189546_a(worldIn, pos.func_177977_b(), (Block)this, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == this) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a(PART, (Comparable)((Object)this.getPlantPart(worldIn, pos)));
    }

    @Override
    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)true)) {
                if (j == 3 && this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K)) {
                    this.func_176474_b(worldIn, rand, pos, state);
                } else if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        } else if (!this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, pos))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (j == 0 && this.canShrink(worldIn, pos)) {
                    this.shrink(worldIn, pos);
                } else if (j > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j - 1)).func_177226_a(PART, (Comparable)((Object)this.getPlantPart((IBlockAccess)worldIn, pos))));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (worldIn.func_180495_p(pos.func_177979_c(this.plant.getMaxHeight())).func_177230_c() == this) {
            return false;
        }
        if (state.func_177230_c() == this) {
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) && this.plant.isValidTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidRain(ChunkDataTFC.getRainfall(worldIn, pos));
        }
        return this.func_185514_i(soil);
    }

    @Override
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getTallBoundingBax((Integer)state.func_177229_b((IProperty)AGE), state, source, pos);
    }

    @Override
    @Nonnull
    protected BlockStateContainer createPlantBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, this.growthStageProperty, PART, DAYPERIOD});
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, worldIn.func_180495_p(pos));
    }

    private boolean canShrink(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this;
    }
}

