/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.entity.EntityFallingBlockTFC;
import net.dries007.tfc.util.IFallingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRockVariantFallable
extends BlockRockVariant
implements IFallingBlock {
    public static boolean isSupportingSideBlock(IBlockState state) {
        return state.func_185915_l() || state.func_177230_c() instanceof BlockRockVariant && (((BlockRockVariant)state.func_177230_c()).getType() == Rock.Type.FARMLAND || ((BlockRockVariant)state.func_177230_c()).getType() == Rock.Type.PATH);
    }

    public BlockRockVariantFallable(Rock.Type type, Rock rock) {
        super(type, rock);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!this.type.canFall()) {
            return;
        }
        if (rand.nextInt(16) != 0) {
            return;
        }
        if (this.shouldFall(worldIn, pos, pos)) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (this.checkFalling(worldIn, pos, state)) {
            this.onRockSlide(worldIn, pos);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (this.checkFalling(worldIn, pos, state)) {
            this.onRockSlide(worldIn, pos);
        }
    }

    @Override
    @Nullable
    public BlockPos getFallablePos(World world, BlockPos pos, boolean ignoreSupportChecks) {
        if (this.type.canFall() && this.shouldFall(world, pos, pos, ignoreSupportChecks)) {
            return this.checkAreaClear(world, pos);
        }
        if (this.type.canFallHorizontal()) {
            if (BlockRockVariantFallable.isSupportingSideBlock(world.func_180495_p(pos.func_177984_a()))) {
                return null;
            }
            EnumFacing[] faces = (EnumFacing[])Arrays.stream(EnumFacing.field_176754_o).filter(x -> BlockRockVariantFallable.isSupportingSideBlock(world.func_180495_p(pos.func_177972_a(x)))).toArray(EnumFacing[]::new);
            if (faces.length >= 2) {
                return null;
            }
            IBlockState originalState = world.func_180495_p(pos);
            faces = (EnumFacing[])Arrays.stream(EnumFacing.field_176754_o).filter(x -> this.shouldFall(world, pos.func_177972_a(x), pos, ignoreSupportChecks) && IFallingBlock.canFallThrough(world, pos.func_177972_a(x), originalState.func_185904_a())).toArray(EnumFacing[]::new);
            if (faces.length >= 1) {
                return this.checkAreaClear(world, pos.func_177972_a(faces[RANDOM.nextInt(faces.length)]));
            }
        }
        return null;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.type == Rock.Type.GRAVEL) {
            if (fortune > 3) {
                fortune = 3;
            }
            if (rand.nextInt(10 - fortune * 3) == 0) {
                return Items.field_151145_ak;
            }
        }
        return super.func_180660_a(state, rand, fortune);
    }

    @Nullable
    private BlockPos checkAreaClear(World world, BlockPos pos) {
        if (!world.func_72872_a(EntityFallingBlockTFC.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1))).isEmpty()) {
            world.func_175684_a(pos, (Block)this, 20);
            return null;
        }
        return pos;
    }
}

