/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.te.TEBarrel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockBarrel
extends Block
implements IItemSize {
    public static final PropertyBool SEALED = PropertyBool.func_177716_a((String)"sealed");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public static void toggleBarrelSeal(World world, BlockPos pos) {
        TEBarrel tile = Helpers.getTE((IBlockAccess)world, pos, TEBarrel.class);
        if (tile != null) {
            IBlockState state;
            boolean previousSealed = (Boolean)(state = world.func_180495_p(pos)).func_177229_b((IProperty)SEALED);
            world.func_175656_a(pos, state.func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                tile.onUnseal();
            } else {
                tile.onSealed();
            }
        }
    }

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return stack.func_77978_p() == null ? Size.VERY_LARGE : Size.HUGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Override
    public boolean canStack(@Nonnull ItemStack stack) {
        return stack.func_77978_p() == null;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SEALED) != false ? 1 : 0;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean powered;
        if (!world.field_72995_K && ((powered = world.func_175640_z(pos)) || block.func_176223_P().func_185897_m()) && powered != (Boolean)state.func_177229_b((IProperty)SEALED)) {
            BlockBarrel.toggleBarrelSeal(world, pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEBarrel tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEBarrel.class);
        if (tile != null) {
            tile.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TEBarrel te = Helpers.getTE((IBlockAccess)worldIn, pos, TEBarrel.class);
        if (te != null) {
            if (heldItem.func_190926_b() && playerIn.func_70093_af()) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 0.85f);
                BlockBarrel.toggleBarrelSeal(worldIn, pos);
                return true;
            }
            if (heldItem.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && !((Boolean)state.func_177229_b((IProperty)SEALED)).booleanValue()) {
                IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (fluidHandler != null) {
                    if (!worldIn.field_72995_K) {
                        FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)fluidHandler);
                        te.func_70296_d();
                    }
                    return true;
                }
            } else {
                if (!worldIn.field_72995_K) {
                    TFCGuiHandler.openGui(worldIn, pos, playerIn, TFCGuiHandler.Type.BARREL);
                }
                return true;
            }
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TEBarrel te;
        if (!worldIn.field_72995_K && stack.func_77978_p() != null && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TEBarrel.class)) != null) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(true)));
            te.loadFromItemStack(stack);
        }
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SEALED});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEBarrel();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (!((Boolean)state.func_177229_b((IProperty)SEALED)).booleanValue()) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)SEALED, (Comparable)Boolean.valueOf(false)));
        super.onBlockExploded(world, pos, explosion);
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(state.func_177230_c());
        TEBarrel tile = Helpers.getTE((IBlockAccess)world, pos, TEBarrel.class);
        if (tile != null && tile.isSealed()) {
            tile.saveToItemStack(stack);
        }
        return stack;
    }
}

