/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockLogTFC
extends BlockLog
implements IItemSize {
    public static final PropertyBool PLACED = PropertyBool.func_177716_a((String)"placed");
    public static final PropertyBool SMALL = PropertyBool.func_177716_a((String)"small");
    public static final AxisAlignedBB SMALL_AABB_Y = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final AxisAlignedBB SMALL_AABB_X = new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
    public static final AxisAlignedBB SMALL_AABB_Z = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
    private static final Map<Tree, BlockLogTFC> MAP = new HashMap<Tree, BlockLogTFC>();
    private final Tree wood;

    public static BlockLogTFC get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public BlockLogTFC(Tree wood) {
        this.wood = wood;
        if (MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)PLACED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SMALL, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        OreDictionaryHelper.register((Block)this, "log", "wood");
        OreDictionaryHelper.register((Block)this, "log", "wood", wood.getRegistryName().func_110623_a());
        if (wood.canMakeTannin()) {
            OreDictionaryHelper.register((Block)this, "log", "wood", "tannin");
        }
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
        this.func_149675_a(true);
    }

    public boolean func_149730_j(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SMALL) == false;
    }

    public int func_149717_k(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SMALL) != false ? 0 : 255;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SMALL) == false;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((Boolean)blockState.func_177229_b((IProperty)PLACED) != false ? 1.0f : 2.5f) * super.func_176195_g(blockState, worldIn, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)SMALL)).booleanValue()) {
            return field_185505_j;
        }
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                return SMALL_AABB_X;
            }
            case Y: {
                return SMALL_AABB_Y;
            }
            case Z: {
                return SMALL_AABB_Z;
            }
        }
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SMALL) == false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)PLACED)).booleanValue()) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (world.func_180495_p(pos.func_177982_a(x, y, z)).func_177230_c() != this || z == 0 && y == 0 && x == 0) continue;
                    return;
                }
            }
        }
        world.func_175698_g(pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K) {
            this.removeTree(worldIn, pos, null, ItemStack.field_190927_a, false);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        Set toolClasses = stack.func_77973_b().getToolClasses(stack);
        if (toolClasses.contains("axe") || toolClasses.contains("saw")) {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        } else if (toolClasses.contains("hammer") && ConfigTFC.General.TREE.enableHammerSticks) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            if (!worldIn.field_72995_K) {
                Helpers.spawnItemStack(worldIn, pos.func_177963_a(0.5, 0.5, 0.5), new ItemStack(Items.field_151055_y, 1 + (int)(Math.random() * 3.0)));
            }
        } else if (ConfigTFC.General.TREE.requiresAxe) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        Set toolClasses;
        ItemStack stack = ItemStack.field_190927_a;
        IPlayerData cap = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
        if (cap != null) {
            stack = cap.getHarvestingTool();
        }
        if (stack.func_190926_b()) {
            stack = player.func_184614_ca();
        }
        if ((toolClasses = stack.func_77973_b().getToolClasses(stack)).contains("axe") && !toolClasses.contains("saw")) {
            if (!((Boolean)state.func_177229_b((IProperty)PLACED)).booleanValue() && ConfigTFC.General.TREE.enableFelling) {
                player.func_184611_a(EnumHand.MAIN_HAND, stack);
                if (!this.removeTree(world, pos, player, stack, OreDictionaryHelper.doesStackMatchOre(stack, "axeStone") || OreDictionaryHelper.doesStackMatchOre(stack, "hammerStone"))) {
                    return false;
                }
                return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            }
        } else {
            if (toolClasses.contains("hammer") && ConfigTFC.General.TREE.enableHammerSticks) {
                return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            }
            if (!toolClasses.contains("saw") && ConfigTFC.General.TREE.requiresAxe) {
                return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return "hammer".equals(type) && ConfigTFC.General.TREE.enableHammerSticks || super.isToolEffective(type, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.values()[meta & 3]).func_177226_a((IProperty)PLACED, (Comparable)Boolean.valueOf((meta & 4) == 4)).func_177226_a((IProperty)SMALL, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)).ordinal() | ((Boolean)state.func_177229_b((IProperty)PLACED) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)SMALL) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176299_a, PLACED, SMALL});
    }

    public Tree getWood() {
        return this.wood;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)PLACED, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public Size getSize(ItemStack stack) {
        return Size.VERY_LARGE;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    private boolean removeTree(World world, BlockPos pos, @Nullable EntityPlayer player, ItemStack stack, boolean stoneTool) {
        boolean explosion = stack.func_190926_b() || player == null;
        int maxLogs = explosion ? Integer.MAX_VALUE : 1 + stack.func_77958_k() - stack.func_77952_i();
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>(50);
        HashSet<BlockPos> checked = new HashSet<BlockPos>(450);
        logs.add(pos);
        for (int i = 0; i < logs.size(); ++i) {
            BlockPos pos1 = (BlockPos)logs.get(i);
            for (int x2 = -1; x2 <= 1; ++x2) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos pos2 = pos1.func_177982_a(x2, y, z);
                        if (checked.contains(pos2)) continue;
                        checked.add(pos2);
                        IBlockState state = world.func_180495_p(pos2);
                        if (state.func_177230_c() != this || ((Boolean)state.func_177229_b((IProperty)PLACED)).booleanValue()) continue;
                        logs.add(pos2);
                    }
                }
            }
        }
        logs.sort(Comparator.comparing(x -> -x.func_177951_i((Vec3i)pos)));
        for (BlockPos pos1 : logs.subList(0, Math.min(logs.size(), maxLogs))) {
            if (explosion) {
                if ((double)Constants.RNG.nextFloat() < 0.3 && !world.field_72995_K) {
                    Helpers.spawnItemStack(world, pos.func_177963_a(0.5, 0.5, 0.5), new ItemStack(Item.func_150898_a((Block)this)));
                }
            } else {
                if (!stoneTool || (double)Constants.RNG.nextFloat() < ConfigTFC.General.TREE.stoneAxeReturnRate && !world.field_72995_K) {
                    this.func_180657_a(world, player, pos1, world.func_180495_p(pos1), null, stack);
                }
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            if (world.field_72995_K) continue;
            world.func_175698_g(pos1);
        }
        return maxLogs >= logs.size();
    }
}

