/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.te.TELoom;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockLoom
extends BlockContainer
implements IItemSize {
    protected static final AxisAlignedBB LOOM_EAST_AABB = new AxisAlignedBB(0.125, 0.0, 0.0625, 0.5625, 1.0, 0.9375);
    protected static final AxisAlignedBB LOOM_WEST_AABB = new AxisAlignedBB(0.4375, 0.0, 0.0625, 0.875, 1.0, 0.9375);
    protected static final AxisAlignedBB LOOM_SOUTH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.125, 0.9375, 1.0, 0.5625);
    protected static final AxisAlignedBB LOOM_NORTH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.4375, 0.9375, 1.0, 0.875);
    private static final Map<Tree, BlockLoom> MAP = new HashMap<Tree, BlockLoom>();
    public Tree wood;

    public static BlockLoom get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public BlockLoom(Tree wood) {
        super(Material.field_151575_d, MapColor.field_151660_b);
        if (MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.wood = wood;
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TELoom();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            default: {
                return LOOM_NORTH_AABB;
            }
            case SOUTH: {
                return LOOM_SOUTH_AABB;
            }
            case WEST: {
                return LOOM_WEST_AABB;
            }
            case EAST: 
        }
        return LOOM_EAST_AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TELoom te = Helpers.getTE((IBlockAccess)worldIn, pos, TELoom.class);
        if (te != null) {
            return te.onRightClick(playerIn);
        }
        return true;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = placer.func_174811_aO().func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D});
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TELoom te = Helpers.getTE((IBlockAccess)worldIn, pos, TELoom.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

