/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class BlockSaplingTFC
extends BlockBush
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)4);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.9, 0.9);
    private static final Map<Tree, BlockSaplingTFC> MAP = new HashMap<Tree, BlockSaplingTFC>();
    private final Tree wood;

    public static BlockSaplingTFC get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public BlockSaplingTFC(Tree wood) {
        if (MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.wood = wood;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        OreDictionaryHelper.register((Block)this, "tree", "sapling");
        OreDictionaryHelper.register((Block)this, "tree", "sapling", wood.getRegistryName().func_110623_a());
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TETickCounter te = Helpers.getTE((IBlockAccess)worldIn, pos, TETickCounter.class);
        if (te != null) {
            te.resetCounter();
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TETickCounter();
    }

    public Tree getWood() {
        return this.wood;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        long days;
        TETickCounter te;
        super.func_180650_b(world, pos, state, random);
        if (!world.field_72995_K && (te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class)) != null && (float)(days = te.getTicksSinceUpdate() / 24000L) > this.wood.getMinGrowthTime()) {
            this.func_176474_b(world, random, pos, state);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public boolean func_176473_a(World world, BlockPos blockPos, IBlockState iBlockState, boolean b) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, IBlockState iBlockState) {
        return false;
    }

    public void func_176474_b(World world, Random random, BlockPos blockPos, IBlockState blockState) {
        this.wood.makeTree(world, blockPos, random, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        this.wood.addInfo(stack, worldIn, tooltip, flagIn);
    }
}

