/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class BlockSupport
extends Block {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final AxisAlignedBB VERTICAL_SUPPORT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    private static final AxisAlignedBB HORIZONTAL_SUPPORT_AABB = new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB CONNECTION_N_AABB = new AxisAlignedBB(0.3125, 0.625, 0.0, 0.6875, 1.0, 0.3125);
    private static final AxisAlignedBB CONNECTION_S_AABB = new AxisAlignedBB(0.3125, 0.625, 0.6875, 0.6875, 1.0, 1.0);
    private static final AxisAlignedBB CONNECTION_E_AABB = new AxisAlignedBB(0.6875, 0.625, 0.3125, 1.0, 1.0, 0.6875);
    private static final AxisAlignedBB CONNECTION_W_AABB = new AxisAlignedBB(0.0, 0.625, 0.3125, 0.3125, 1.0, 0.6875);
    private static final Map<Tree, BlockSupport> MAP = new HashMap<Tree, BlockSupport>();
    private final Tree wood;

    public static BlockSupport get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public static ItemStack get(Tree wood, int amount) {
        return new ItemStack((Block)MAP.get((Object)wood), amount);
    }

    public static boolean isBeingSupported(World worldIn, BlockPos pos) {
        int sRangeHor = ConfigTFC.General.FALLABLE.supportBeamRangeHor;
        int sRangeVert = ConfigTFC.General.FALLABLE.supportBeamRangeUp;
        int sRangeHorNeg = ConfigTFC.General.FALLABLE.supportBeamRangeHor * -1;
        int sRangeVertNeg = ConfigTFC.General.FALLABLE.supportBeamRangeDown * -1;
        if (!worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
            return true;
        }
        for (BlockPos.MutableBlockPos searchSupport : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(sRangeHorNeg, sRangeVertNeg, sRangeHorNeg), (BlockPos)pos.func_177982_a(sRangeHor, sRangeVert, sRangeHor))) {
            IBlockState st = worldIn.func_180495_p((BlockPos)searchSupport);
            if (!(st.func_177230_c() instanceof BlockSupport) || !((BlockSupport)st.func_177230_c()).canSupportBlocks((IBlockAccess)worldIn, (BlockPos)searchSupport)) continue;
            return true;
        }
        return false;
    }

    public static Set<BlockPos> getAllUnsupportedBlocksIn(World worldIn, BlockPos from, BlockPos to) {
        HashSet<BlockPos> listSupported = new HashSet<BlockPos>();
        HashSet<BlockPos> listUnsupported = new HashSet<BlockPos>();
        int minX = Math.min(from.func_177958_n(), to.func_177958_n());
        int maxX = Math.max(from.func_177958_n(), to.func_177958_n());
        int minY = Math.min(from.func_177956_o(), to.func_177956_o());
        int maxY = Math.max(from.func_177956_o(), to.func_177956_o());
        int minZ = Math.min(from.func_177952_p(), to.func_177952_p());
        int maxZ = Math.max(from.func_177952_p(), to.func_177952_p());
        int sRangeHor = ConfigTFC.General.FALLABLE.supportBeamRangeHor;
        int sRangeVert = ConfigTFC.General.FALLABLE.supportBeamRangeUp;
        int sRangeHorNeg = ConfigTFC.General.FALLABLE.supportBeamRangeHor * -1;
        int sRangeVertNeg = ConfigTFC.General.FALLABLE.supportBeamRangeDown * -1;
        BlockPos minPoint = new BlockPos(minX, minY, minZ);
        BlockPos maxPoint = new BlockPos(maxX, maxY, maxZ);
        for (BlockPos.MutableBlockPos searchingPoint : BlockPos.func_177975_b((BlockPos)minPoint.func_177982_a(sRangeHorNeg, sRangeVertNeg, sRangeHorNeg), (BlockPos)maxPoint.func_177982_a(sRangeHor, sRangeVert, sRangeHor))) {
            IBlockState st;
            if (!listSupported.contains(searchingPoint)) {
                listUnsupported.add(searchingPoint.func_185334_h());
            }
            if (!((st = worldIn.func_180495_p((BlockPos)searchingPoint)).func_177230_c() instanceof BlockSupport) || !((BlockSupport)st.func_177230_c()).canSupportBlocks((IBlockAccess)worldIn, (BlockPos)searchingPoint)) continue;
            for (BlockPos.MutableBlockPos supported : BlockPos.func_177975_b((BlockPos)searchingPoint.func_177982_a(sRangeHorNeg, sRangeVertNeg, sRangeHorNeg), (BlockPos)searchingPoint.func_177982_a(sRangeHor, sRangeVert, sRangeHor))) {
                listSupported.add(supported.func_185334_h());
                listUnsupported.remove(supported);
            }
        }
        listUnsupported.removeIf(content -> content.func_177958_n() < minX || content.func_177958_n() > maxX || content.func_177956_o() < minY || content.func_177956_o() > maxY || content.func_177952_p() < minZ || content.func_177952_p() > maxZ);
        return listUnsupported;
    }

    public BlockSupport(Tree wood) {
        super(Material.field_151575_d, Material.field_151575_d.func_151565_r());
        if (MAP.put(wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.wood = wood;
        OreDictionaryHelper.register(this, "support");
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public Tree getWood() {
        return this.wood;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing.Axis)state.func_177229_b(AXIS)).ordinal();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isConnectable(worldIn, pos, EnumFacing.WEST)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB value;
        AxisAlignedBB axisAlignedBB = value = state.func_177229_b(AXIS) == EnumFacing.Axis.Y ? VERTICAL_SUPPORT_AABB : HORIZONTAL_SUPPORT_AABB;
        if (this.isConnectable(source, pos, EnumFacing.NORTH)) {
            value = value.func_111270_a(CONNECTION_N_AABB);
        }
        if (this.isConnectable(source, pos, EnumFacing.SOUTH)) {
            value = value.func_111270_a(CONNECTION_S_AABB);
        }
        if (this.isConnectable(source, pos, EnumFacing.EAST)) {
            value = value.func_111270_a(CONNECTION_E_AABB);
        }
        if (this.isConnectable(source, pos, EnumFacing.WEST)) {
            value = value.func_111270_a(CONNECTION_W_AABB);
        }
        return value;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_185477_a(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.Y) {
            BlockSupport.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)VERTICAL_SUPPORT_AABB);
        } else {
            BlockSupport.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HORIZONTAL_SUPPORT_AABB);
        }
        if (this.isConnectable((IBlockAccess)worldIn, pos, EnumFacing.NORTH)) {
            BlockSupport.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CONNECTION_N_AABB);
        }
        if (this.isConnectable((IBlockAccess)worldIn, pos, EnumFacing.SOUTH)) {
            BlockSupport.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CONNECTION_S_AABB);
        }
        if (this.isConnectable((IBlockAccess)worldIn, pos, EnumFacing.EAST)) {
            BlockSupport.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CONNECTION_E_AABB);
        }
        if (this.isConnectable((IBlockAccess)worldIn, pos, EnumFacing.WEST)) {
            BlockSupport.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CONNECTION_W_AABB);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!this.canBlockStay((IBlockAccess)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_176198_a(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return world.func_180495_p(pos.func_177977_b()).func_185915_l() || this.isConnectable((IBlockAccess)world, pos, EnumFacing.DOWN);
        }
        if (!this.isConnectable((IBlockAccess)world, pos, side.func_176734_d())) {
            return false;
        }
        int distance = this.getHorizontalDistance(side, (IBlockAccess)world, pos);
        return distance > 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block itemBlock;
        ItemStack heldStack = player.func_184586_b(hand);
        if (player.func_70093_af() && heldStack.func_77973_b() instanceof ItemBlock && (itemBlock = ((ItemBlock)heldStack.func_77973_b()).func_179223_d()) instanceof BlockSupport) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
            while (mutablePos.func_177956_o() <= pos.func_177956_o() + 5) {
                if (world.func_180495_p((BlockPos)mutablePos).func_185904_a().func_76222_j()) {
                    if (!world.field_72995_K) {
                        world.func_180501_a((BlockPos)mutablePos, itemBlock.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y), 2);
                    }
                    if (!player.func_184812_l_()) {
                        heldStack.func_190918_g(1);
                    }
                    return true;
                }
                mutablePos.func_185336_p(mutablePos.func_177956_o() + 1);
            }
        }
        return false;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)facing.func_176740_k());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.field_72995_K) {
            return;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.Y) {
            if (!this.isConnectable((IBlockAccess)worldIn, pos, EnumFacing.DOWN) && !placer.func_70093_af() && stack.func_190916_E() > 2 && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_175623_d(pos.func_177981_b(2)) && worldIn.func_72855_b(new AxisAlignedBB(pos.func_177984_a()))) {
                worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y), 2);
                if (worldIn.func_72855_b(new AxisAlignedBB(pos.func_177981_b(2)))) {
                    worldIn.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y), 2);
                    stack.func_190918_g(2);
                } else {
                    stack.func_190918_g(1);
                }
            }
        } else {
            int distance;
            EnumFacing face = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
            if (this.isConnectable((IBlockAccess)worldIn, pos, face)) {
                face = face.func_176734_d();
            }
            if ((distance = this.getHorizontalDistance(face, (IBlockAccess)worldIn, pos)) == 0 || stack.func_190916_E() < distance) {
                worldIn.func_175655_b(pos, true);
            } else if (distance > 0) {
                stack.func_190918_g(distance - 1);
                for (int i = 1; i < distance; ++i) {
                    if (!worldIn.func_180495_p(pos.func_177967_a(face, i)).func_185904_a().func_76222_j()) continue;
                    worldIn.func_180501_a(pos.func_177967_a(face, i), this.func_176223_P().func_177226_a(AXIS, (Comparable)axis), 2);
                    worldIn.func_180497_b(pos.func_177967_a(face, i).func_177977_b(), worldIn.func_180495_p(pos.func_177967_a(face, i).func_177977_b()).func_177230_c(), 3, 2);
                }
            }
        }
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, NORTH, SOUTH, EAST, WEST});
    }

    private boolean canSupportBlocks(IBlockAccess world, BlockPos pos) {
        return this.canBlockStay(world, pos) && world.func_180495_p(pos).func_177229_b(AXIS) != EnumFacing.Axis.Y;
    }

    private boolean isConnectable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
        return state.func_177230_c() instanceof BlockSupport;
    }

    private boolean isThreeTall(IBlockAccess world, BlockPos pos) {
        if (!this.canBlockStay(world, pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis != EnumFacing.Axis.Y) {
            return false;
        }
        if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockSupport)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b().func_177977_b()).func_177230_c() instanceof BlockSupport;
    }

    private boolean canBlockStay(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockSupport)) {
            return false;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis == EnumFacing.Axis.Y) {
            return world.func_180495_p(pos.func_177977_b()).func_185915_l() || this.isConnectable(world, pos, EnumFacing.DOWN);
        }
        return this.isConnectable(world, pos, EnumFacing.WEST) && this.isConnectable(world, pos, EnumFacing.EAST) || this.isConnectable(world, pos, EnumFacing.NORTH) && this.isConnectable(world, pos, EnumFacing.SOUTH);
    }

    private int getHorizontalDistance(EnumFacing face, IBlockAccess worldIn, BlockPos pos) {
        if (!this.isThreeTall(worldIn, pos.func_177972_a(face.func_176734_d()))) {
            return 0;
        }
        int distance = -1;
        for (int i = 0; i < 5; ++i) {
            IBlockState state = worldIn.func_180495_p(pos.func_177967_a(face, i + 1));
            if (state.func_177230_c() instanceof BlockSupport && state.func_177229_b(AXIS) == EnumFacing.Axis.Y) {
                distance = i;
                break;
            }
            if (worldIn.func_180495_p(pos.func_177967_a(face, i)).func_177230_c() instanceof BlockSupport || worldIn.func_175623_d(pos.func_177967_a(face, i))) continue;
            return 0;
        }
        if (distance == -1) {
            return 0;
        }
        if (!this.isThreeTall(worldIn, pos.func_177967_a(face, distance + 1))) {
            return 0;
        }
        return distance + 1;
    }
}

