/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.container;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.dries007.tfc.objects.container.ContainerSimple;
import net.dries007.tfc.objects.inventory.capability.ISlotCallback;
import net.dries007.tfc.objects.inventory.capability.ItemStackHandlerCallback;
import net.dries007.tfc.objects.inventory.slot.SlotCallback;
import net.dries007.tfc.objects.items.food.ItemDynamicBowlFood;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.agriculture.Food;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class ContainerSalad
extends ContainerSimple
implements ISlotCallback {
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 4;
    public static final int SLOT_BOWLS = 5;
    public static final int SLOT_OUTPUT = 6;
    private final ItemStackHandler inventory = new ItemStackHandlerCallback(this, 7){

        @Override
        protected void onContentsChanged(int slot) {
        }
    };
    private boolean skipOutputUpdates = false;

    public ContainerSalad(InventoryPlayer playerInv) {
        ItemStack bowl = playerInv.field_70458_d.func_184614_ca();
        if (OreDictionaryHelper.doesStackMatchOre(bowl, "bowl")) {
            this.inventory.setStackInSlot(5, bowl);
            playerInv.field_70458_d.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        } else {
            bowl = playerInv.field_70458_d.func_184592_cb();
            if (OreDictionaryHelper.doesStackMatchOre(bowl, "bowl")) {
                this.inventory.setStackInSlot(5, bowl);
                playerInv.field_70458_d.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            }
        }
        this.addContainerSlots();
        this.addPlayerInventorySlots(playerInv);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || i == 6) continue;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)stack);
        }
        super.func_75134_a(playerIn);
    }

    public ItemStack onTakeSalad(ItemStack saladStackTaken) {
        int amountCreated = saladStackTaken.func_190916_E();
        for (int i = 0; i <= 5; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            stack.func_190918_g(amountCreated);
        }
        return saladStackTaken;
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        switch (slot) {
            case 5: {
                return OreDictionaryHelper.doesStackMatchOre(stack, "bowl");
            }
            case 6: {
                return false;
            }
        }
        return stack.hasCapability(CapabilityFood.CAPABILITY, null) && Food.Category.doesStackMatchCategories(stack, Food.Category.VEGETABLE, Food.Category.FRUIT, Food.Category.COOKED_MEAT, Food.Category.DAIRY);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        if (!this.skipOutputUpdates) {
            ItemStack bowlStack = this.inventory.getStackInSlot(5);
            if (!bowlStack.func_190926_b()) {
                float water = 0.0f;
                float saturation = 0.0f;
                float[] nutrition = new float[Nutrient.TOTAL];
                int ingredientCount = 0;
                int minIngredientCount = 64;
                for (int i = 0; i <= 4; ++i) {
                    ItemStack ingredient = this.inventory.getStackInSlot(i);
                    IFood food = (IFood)ingredient.getCapability(CapabilityFood.CAPABILITY, null);
                    if (food == null) continue;
                    if (food.isRotten()) {
                        ingredientCount = 0;
                        break;
                    }
                    water += food.getData().getWater();
                    saturation += food.getData().getSaturation();
                    float[] fArray = food.getData().getNutrients();
                    Nutrient[] nutrientArray = Nutrient.values();
                    int n = nutrientArray.length;
                    for (int j = 0; j < n; ++j) {
                        Nutrient nutrient = nutrientArray[j];
                        int n2 = nutrient.ordinal();
                        nutrition[n2] = nutrition[n2] + fArray[nutrient.ordinal()];
                    }
                    ++ingredientCount;
                    if (ingredient.func_190916_E() >= minIngredientCount) continue;
                    minIngredientCount = ingredient.func_190916_E();
                }
                if (bowlStack.func_190916_E() < minIngredientCount) {
                    minIngredientCount = bowlStack.func_190916_E();
                }
                if (ingredientCount > 0) {
                    float multiplier = 0.75f;
                    water *= multiplier;
                    saturation *= multiplier;
                    Nutrient maxNutrient = null;
                    float maxNutrientValue = 0.0f;
                    for (Nutrient nutrient : Nutrient.values()) {
                        int n = nutrient.ordinal();
                        nutrition[n] = nutrition[n] * multiplier;
                        if (!(nutrition[nutrient.ordinal()] > maxNutrientValue)) continue;
                        maxNutrientValue = nutrition[nutrient.ordinal()];
                        maxNutrient = nutrient;
                    }
                    if (maxNutrient != null) {
                        ItemStack itemStack = new ItemStack(this.getSaladItem(maxNutrient), minIngredientCount);
                        IFood saladCap = (IFood)itemStack.getCapability(CapabilityFood.CAPABILITY, null);
                        if (saladCap instanceof ItemDynamicBowlFood.DynamicFoodHandler) {
                            saladCap.setCreationDate(CapabilityFood.getRoundedCreationDate());
                            ((ItemDynamicBowlFood.DynamicFoodHandler)saladCap).initCreationDataAndBowl(bowlStack.func_77946_l().func_77979_a(1), new FoodData(4, water, saturation, nutrition, Food.SALAD_VEGETABLE.getData().getDecayModifier()));
                        }
                        this.inventory.setStackInSlot(6, itemStack);
                        return;
                    }
                }
            }
            if (!this.inventory.getStackInSlot(6).func_190926_b()) {
                this.inventory.setStackInSlot(6, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack stackCopy = stack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots) {
                if (index == 6) {
                    this.skipOutputUpdates = true;
                }
                if (!this.func_75135_a(stack, containerSlots, this.field_75151_b.size(), true)) {
                    this.skipOutputUpdates = false;
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stack, 0, 6, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == stackCopy.func_190916_E()) {
                this.skipOutputUpdates = false;
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackCopy);
            this.skipOutputUpdates = false;
            return stackCopy;
        }
        return ItemStack.field_190927_a;
    }

    private void addContainerSlots() {
        for (int i = 0; i <= 4; ++i) {
            this.func_75146_a((Slot)new SlotCallback((IItemHandler)this.inventory, i, 44 + 18 * i, 24, this));
        }
        this.func_75146_a((Slot)new SlotCallback((IItemHandler)this.inventory, 5, 44, 56, this));
        this.func_75146_a((Slot)new SlotCallback((IItemHandler)this.inventory, 6, 116, 56, this){

            @Nonnull
            public ItemStack func_190901_a(EntityPlayer player, @Nonnull ItemStack stack) {
                return ContainerSalad.this.onTakeSalad(stack);
            }
        });
    }

    @Nonnull
    private Item getSaladItem(Nutrient nutrient) {
        switch (nutrient) {
            case GRAIN: {
                return ItemFoodTFC.get(Food.SALAD_GRAIN);
            }
            case VEGETABLES: {
                return ItemFoodTFC.get(Food.SALAD_VEGETABLE);
            }
            case FRUIT: {
                return ItemFoodTFC.get(Food.SALAD_FRUIT);
            }
            case PROTEIN: {
                return ItemFoodTFC.get(Food.SALAD_MEAT);
            }
        }
        return ItemFoodTFC.get(Food.SALAD_DAIRY);
    }
}

