/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.container;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.objects.container.ContainerSimple;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TEInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public abstract class ContainerTE<T extends TEInventory>
extends ContainerSimple {
    protected final T tile;
    protected final EntityPlayer player;
    private final boolean shouldSyncFields;
    private final int yOffset;
    private int[] cachedFields;

    protected ContainerTE(InventoryPlayer playerInv, T tile) {
        this(playerInv, tile, 0);
    }

    protected ContainerTE(InventoryPlayer playerInv, T tile, int yOffset) {
        this.tile = tile;
        this.player = playerInv.field_70458_d;
        this.shouldSyncFields = tile instanceof ITileFields;
        this.yOffset = yOffset;
        this.addContainerSlots();
        this.addPlayerInventorySlots(playerInv);
    }

    public void func_75142_b() {
        if (this.shouldSyncFields) {
            this.detectAndSendFieldChanges();
        }
        super.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (this.shouldSyncFields) {
            ((ITileFields)this.tile).setField(id, data);
        }
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack stackCopy = stack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? this.transferStackOutOfContainer(stack, containerSlots) : this.transferStackIntoContainer(stack, containerSlots)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == stackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackCopy);
            return stackCopy;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        return ((TEInventory)this.tile).canInteractWith(this.player);
    }

    @Override
    protected void addPlayerInventorySlots(InventoryPlayer playerInv) {
        super.addPlayerInventorySlots(playerInv, this.yOffset);
    }

    protected abstract void addContainerSlots();

    protected void detectAndSendFieldChanges() {
        ITileFields tileFields = (ITileFields)this.tile;
        boolean allFieldsHaveChanged = false;
        boolean[] fieldHasChanged = new boolean[tileFields.getFieldCount()];
        if (this.cachedFields == null) {
            this.cachedFields = new int[tileFields.getFieldCount()];
            allFieldsHaveChanged = true;
        }
        for (int i = 0; i < this.cachedFields.length; ++i) {
            if (!allFieldsHaveChanged && this.cachedFields[i] == tileFields.getField(i)) continue;
            this.cachedFields[i] = tileFields.getField(i);
            fieldHasChanged[i] = true;
        }
        for (IContainerListener listener : this.field_75149_d) {
            for (int fieldID = 0; fieldID < tileFields.getFieldCount(); ++fieldID) {
                if (!fieldHasChanged[fieldID]) continue;
                listener.func_71112_a((Container)this, fieldID, this.cachedFields[fieldID]);
            }
        }
    }

    protected boolean transferStackOutOfContainer(ItemStack stack, int containerSlots) {
        return !this.func_75135_a(stack, containerSlots, this.field_75151_b.size(), true);
    }

    protected boolean transferStackIntoContainer(ItemStack stack, int containerSlots) {
        return !this.func_75135_a(stack, 0, containerSlots, false);
    }
}

