/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity;

import com.google.common.base.Optional;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.util.IFallingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class EntityFallingBlockTFC
extends Entity {
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityFallingBlockTFC.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<IBlockState>> BLOCK = EntityDataManager.func_187226_a(EntityFallingBlockTFC.class, (DataSerializer)DataSerializers.field_187197_g);
    private IFallingBlock falling;
    private int fallTime;
    private NBTTagCompound teData;
    private boolean failedBreakCheck;

    public EntityFallingBlockTFC(World worldIn) {
        super(worldIn);
    }

    public EntityFallingBlockTFC(World world, BlockPos start, IFallingBlock falling, IBlockState state) {
        this(world);
        this.falling = falling;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b((float)start.func_177958_n() + 0.5f, (double)start.func_177956_o() + (double)((1.0f - this.field_70131_O) / 2.0f), (float)start.func_177952_p() + 0.5f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70163_u;
        this.field_70180_af.func_187227_b(ORIGIN, (Object)start);
        this.field_70180_af.func_187227_b(BLOCK, (Object)Optional.of((Object)state));
    }

    public IBlockState getState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(BLOCK)).orNull();
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BLOCK, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        BlockPos pos;
        IBlockState state = this.getState();
        if (state == null) {
            return;
        }
        Block block = state.func_177230_c();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.fallTime++ == 0) {
            pos = new BlockPos((Entity)this);
            if (this.field_70170_p.func_180495_p(pos) == state) {
                this.field_70170_p.func_175698_g(pos);
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        pos = new BlockPos((Entity)this);
        if (!this.field_70122_E) {
            this.failedBreakCheck = false;
            if (!((this.fallTime <= 100 || pos.func_177956_o() >= 1 && pos.func_177956_o() <= 256) && this.fallTime <= 600 || this.field_70170_p.field_72995_K)) {
                if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.falling.getDropsFromFall(this.field_70170_p, pos, state, this.teData, this.fallTime, this.field_70143_R).forEach(x -> this.func_70099_a((ItemStack)x, 0.0f));
                }
                this.func_70106_y();
            }
        } else {
            if (!this.failedBreakCheck) {
                if (!this.field_70170_p.func_175623_d(pos) && IFallingBlock.canFallThrough(this.field_70170_p, pos, state.func_185904_a())) {
                    this.field_70170_p.func_175655_b(pos, true);
                    this.failedBreakCheck = true;
                    return;
                }
                if (!this.field_70170_p.func_175623_d(pos.func_177977_b()) && IFallingBlock.canFallThrough(this.field_70170_p, pos.func_177977_b(), state.func_185904_a())) {
                    this.field_70170_p.func_175655_b(pos.func_177977_b(), true);
                    this.failedBreakCheck = true;
                    return;
                }
                if (ConfigTFC.General.FALLABLE.destroyOres && this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockOreTFC) {
                    this.field_70170_p.func_175655_b(pos.func_177977_b(), false);
                    this.failedBreakCheck = true;
                    return;
                }
            }
            IBlockState current = this.field_70170_p.func_180495_p(pos);
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
            if (current.func_177230_c() != Blocks.field_180384_M) {
                this.func_70106_y();
                if (IFallingBlock.canFallThrough(this.field_70170_p, pos, state.func_185904_a())) {
                    if (!this.field_70170_p.field_72995_K) {
                        TileEntity te;
                        this.field_70170_p.func_175655_b(pos, true);
                        this.field_70170_p.func_180501_a(pos, state, 3);
                        if (this.teData != null && block.hasTileEntity(state) && (te = this.field_70170_p.func_175625_s(pos)) != null) {
                            NBTTagCompound currentTeData = te.func_189515_b(new NBTTagCompound());
                            for (String s : this.teData.func_150296_c()) {
                                if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                currentTeData.func_74782_a(s, this.teData.func_74781_a(s).func_74737_b());
                            }
                            te.func_145839_a(currentTeData);
                            te.func_70296_d();
                        }
                    }
                } else if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops") && !this.field_70170_p.field_72995_K) {
                    this.falling.getDropsFromFall(this.field_70170_p, pos, state, this.teData, this.fallTime, this.field_70143_R).forEach(x -> this.func_70099_a((ItemStack)x, 0.0f));
                }
            } else {
                return;
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        for (Entity entity : list) {
            if (ConfigTFC.General.FALLABLE.hurtEntities && distance > 1.0f && entity instanceof EntityLivingBase) {
                entity.func_70097_a(DamageSource.field_82729_p, distance);
                continue;
            }
            if (!ConfigTFC.General.FALLABLE.destroyItems || !(entity instanceof EntityItem)) continue;
            entity.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("State"));
        this.falling = (IFallingBlock)state.func_177230_c();
        if (compound.func_74764_b("State")) {
            this.field_70180_af.func_187227_b(BLOCK, (Object)Optional.of((Object)state));
        }
        this.fallTime = compound.func_74762_e("FallTime");
        if (compound.func_74764_b("TileEntityData")) {
            this.teData = compound.func_74775_l("TileEntityData");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        IBlockState state = this.getState();
        if (state != null) {
            compound.func_74782_a("State", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)state));
        }
        compound.func_74768_a("FallTime", this.fallTime);
        if (this.teData != null) {
            compound.func_74782_a("TileEntityData", (NBTBase)this.teData);
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Origin", (Object)this.getOrigin());
        category.func_71507_a("State", (Object)this.getState());
        category.func_71507_a("FallTime", (Object)this.fallTime);
        category.func_71507_a("TileEntityData", (Object)this.teData);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_184213_bq() {
        return true;
    }
}

