/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AnimalFood {
    private static final HashMap<Class<? extends Entity>, AnimalFood> ANIMAL_FOOD_MAP = new HashMap();
    private final List<Ingredient> acceptedFoods;
    private final boolean eatRotten;

    @Nullable
    public static AnimalFood get(Class<? extends Entity> animalClass) {
        return ANIMAL_FOOD_MAP.get(animalClass);
    }

    public static void readFile(Set<Map.Entry<String, JsonElement>> jsonElements) {
        for (Map.Entry<String, JsonElement> entry : jsonElements) {
            try {
                String entityName = entry.getKey();
                if ("#loader".equals(entityName)) continue;
                ResourceLocation key = new ResourceLocation(entityName);
                EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
                if (entityEntry == null) {
                    throw new JsonParseException("Could not find an entity with registry name " + entityName);
                }
                if (AnimalFood.get(entityEntry.getEntityClass()) != null) {
                    throw new JsonParseException("Another json already registered foods for " + entityName);
                }
                AnimalFood animalFood = (AnimalFood)Constants.GSON.fromJson(entry.getValue(), AnimalFood.class);
                ANIMAL_FOOD_MAP.put(entityEntry.getEntityClass(), animalFood);
                TerraFirmaCraft.getLog().info("Registered animal food data for " + entityName);
            }
            catch (JsonParseException e) {
                TerraFirmaCraft.getLog().error("Error while reading an entry! Skipping.");
                TerraFirmaCraft.getLog().error("Error: ", (Throwable)e);
            }
        }
    }

    public AnimalFood(boolean eatRotten) {
        this.eatRotten = eatRotten;
        this.acceptedFoods = new ArrayList<Ingredient>();
    }

    public void addFood(Ingredient ingredient) {
        this.acceptedFoods.add(ingredient);
    }

    public boolean isFood(ItemStack stack) {
        for (Ingredient acceptedFood : this.acceptedFoods) {
            if (!acceptedFood.apply(stack)) continue;
            if (!this.eatRotten) {
                IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
                return cap == null || !cap.isRotten();
            }
            return true;
        }
        return false;
    }
}

