/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ParametersAreNonnullByDefault
public class EntityOcelotTFC
extends EntityOcelot
implements IAnimalTFC,
ILivestock {
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityOcelotTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityOcelotTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityOcelotTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private long lastFed;
    private long lastFDecay;
    private boolean fertilized;
    private long matingTime;
    private long lastDeath;
    private long pregnantTime;

    public EntityOcelotTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(ConfigTFC.Animals.OCELOT.adulthood, ConfigTFC.Animals.OCELOT.elder));
    }

    public EntityOcelotTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.fertilized = false;
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.4f;
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return this.fertilized;
    }

    @Override
    public void setFertilized(boolean value) {
        this.fertilized = value;
    }

    @Override
    public void onFertilized(@Nonnull IAnimalTFC male) {
        this.pregnantTime = CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.OCELOT.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.OCELOT.elder;
    }

    @Override
    public boolean isReadyToMate() {
        if (this.getAge() != IAnimalTFC.Age.ADULT || this.getFamiliarity() < 0.3f || this.isFertilized() || this.isHungry()) {
            return false;
        }
        return this.matingTime + 2000L <= CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = this.func_70909_n() ? "cattfc" : EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TROPICAL_FOREST && biomeType != BiomeHelper.BiomeType.SAVANNA)) {
            return ConfigTFC.Animals.OCELOT.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.MOTHER_AND_CHILDREN_OR_SOLO_MALE;
    }

    @Override
    public int getMinGroupSize() {
        return 1;
    }

    @Override
    public int getMaxGroupSize() {
        return 4;
    }

    public long gestationDays() {
        return ConfigTFC.Animals.OCELOT.gestation;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.isFertilized() && CalendarTFC.PLAYER_TIME.getTotalDays() >= this.pregnantTime + this.gestationDays()) {
                this.birthChildren();
                this.setFertilized(false);
            }
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getGender() == IAnimalTFC.Gender.MALE && this.isReadyToMate()) {
                this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
                EntityAnimalTFC.findFemaleMate(this);
            }
            if (this.getAge() == IAnimalTFC.Age.OLD && this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
                Random random = new Random(this.field_96093_i.getMostSignificantBits() * CalendarTFC.PLAYER_TIME.getTotalDays());
                if (random.nextDouble() < ConfigTFC.Animals.OCELOT.oldDeathChance) {
                    this.func_70106_y();
                }
            }
        }
    }

    public void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.OCELOT.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            EntityOcelotTFC baby = new EntityOcelotTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            if (this.func_70909_n()) {
                baby.func_184754_b(this.func_184753_b());
                baby.func_70903_f(true);
                baby.func_70912_b(this.func_70913_u());
            }
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        int priority = 1;
        for (String input : ConfigTFC.Animals.OCELOT.huntCreatures) {
            Class entityClass;
            ResourceLocation key = new ResourceLocation(input);
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
            if (entityEntry == null || !EntityLivingBase.class.isAssignableFrom(entityClass = entityEntry.getEntityClass())) continue;
            this.field_70715_bh.func_75776_a(priority++, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, entityClass, false, ent -> true));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74757_a("fertilized", this.fertilized);
        nbt.func_74772_a("mating", this.matingTime);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
        nbt.func_74772_a("pregnant", this.pregnantTime);
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.matingTime = nbt.func_74763_f("mating");
        this.fertilized = nbt.func_74767_n("fertilized");
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
        this.pregnantTime = nbt.func_74763_f("pregnant");
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_OCELOT;
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (!this.func_70909_n()) {
                if (this.isFood(itemstack) && player.func_70068_e((Entity)this) < 9.0) {
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                            this.func_193101_c(player);
                            this.func_70912_b(1 + this.field_70170_p.field_73012_v.nextInt(3));
                            this.func_70908_e(true);
                            this.field_70911_d.func_75270_a(true);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.func_70908_e(false);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    return true;
                }
                return false;
            }
            if (this.isFood(itemstack) && player.func_70093_af() && this.getAdultFamiliarityCap() > 0.0f) {
                if (this.isHungry()) {
                    IFood cap = (IFood)itemstack.getCapability(CapabilityFood.CAPABILITY, null);
                    if (cap != null && cap.isRotten()) {
                        return false;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
                        this.func_175505_a(player, itemstack);
                        if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                            float familiarity = this.getFamiliarity() + 0.06f;
                            if (this.getAge() != IAnimalTFC.Age.CHILD) {
                                familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                            }
                            this.setFamiliarity(familiarity);
                        }
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
                    }
                    return true;
                }
                if (!this.field_70170_p.field_72995_K && this.isFertilized() && this.getType() == IAnimalTFC.Type.MAMMAL) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.animal.mating.pregnant", new Object[]{this.func_70005_c_()}));
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    public EntityOcelotTFC createChild(@Nonnull EntityAgeable other) {
        if (other != this && this.getGender() == IAnimalTFC.Gender.FEMALE && other instanceof IAnimalTFC) {
            this.fertilized = true;
            this.func_70875_t();
            this.onFertilized((IAnimalTFC)other);
        } else if (other == this) {
            EntityOcelotTFC baby = new EntityOcelotTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            if (this.func_70909_n()) {
                baby.func_184754_b(this.func_184753_b());
                baby.func_70903_f(true);
                baby.func_70912_b(this.func_70913_u());
            }
            return baby;
        }
        return null;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        EntityOcelotTFC other = (EntityOcelotTFC)otherAnimal;
        return this.getGender() != other.getGender() && this.func_70880_s() && other.func_70880_s();
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }
}

