/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.dries007.tfc.objects.inventory.ingredient.IngredientFluidStack;
import net.dries007.tfc.objects.inventory.ingredient.IngredientItemStack;
import net.dries007.tfc.objects.inventory.ingredient.IngredientMultipleFluidStack;
import net.dries007.tfc.objects.inventory.ingredient.IngredientOreDict;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public interface IIngredient<T>
extends Predicate<T> {
    public static final IIngredient<?> EMPTY = input -> false;
    public static final IIngredient<?> ANY = input -> true;

    public static <P> IIngredient<P> empty() {
        return EMPTY;
    }

    public static <P> IIngredient<P> any() {
        return ANY;
    }

    public static IIngredient<ItemStack> of(@Nonnull Block predicateBlock) {
        return new IngredientItemStack(new ItemStack(predicateBlock, 1, Short.MAX_VALUE));
    }

    public static IIngredient<ItemStack> of(@Nonnull Item predicateItem) {
        return new IngredientItemStack(new ItemStack(predicateItem, 1, Short.MAX_VALUE));
    }

    public static IIngredient<ItemStack> of(@Nonnull Item predicateItem, int amount) {
        return new IngredientItemStack(new ItemStack(predicateItem, amount, Short.MAX_VALUE));
    }

    public static IIngredient<ItemStack> of(@Nonnull ItemStack predicateStack) {
        return new IngredientItemStack(predicateStack);
    }

    public static IIngredient<ItemStack> of(@Nonnull String oreName) {
        return new IngredientOreDict(oreName);
    }

    public static IIngredient<ItemStack> of(@Nonnull String oreName, int amount) {
        return new IngredientOreDict(oreName, amount);
    }

    public static IIngredient<FluidStack> of(@Nonnull FluidStack predicateStack) {
        return new IngredientFluidStack(predicateStack);
    }

    public static IIngredient<FluidStack> of(@Nonnull Fluid fluid, int amount) {
        return new IngredientFluidStack(fluid, amount);
    }

    public static IIngredient<FluidStack> of(int amount, Fluid ... fluids) {
        return new IngredientMultipleFluidStack(amount, fluids);
    }

    default public NonNullList<T> getValidIngredients() {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean test(T var1);

    default public boolean testIgnoreCount(T input) {
        return this.test(input);
    }

    default public T consume(T input) {
        return input;
    }

    default public int getAmount() {
        return 1;
    }
}

