/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class IngredientFluidStack
implements IIngredient<FluidStack> {
    private final FluidStack inputFluid;

    IngredientFluidStack(@Nonnull Fluid fluid, int amount) {
        this(new FluidStack(fluid, amount));
    }

    IngredientFluidStack(@Nonnull FluidStack inputFluid) {
        this.inputFluid = inputFluid;
    }

    @Override
    public NonNullList<FluidStack> getValidIngredients() {
        return NonNullList.func_191197_a((int)1, (Object)this.inputFluid.copy());
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.testIgnoreCount(fluidStack) && fluidStack.amount >= this.inputFluid.amount;
    }

    @Override
    public boolean testIgnoreCount(FluidStack fluidStack) {
        return fluidStack != null && fluidStack.getFluid() != null && fluidStack.getFluid() == this.inputFluid.getFluid();
    }

    @Override
    @Nullable
    public FluidStack consume(FluidStack input) {
        if (input.amount > this.inputFluid.amount) {
            return new FluidStack(input.getFluid(), input.amount - this.inputFluid.amount);
        }
        return null;
    }

    @Override
    public int getAmount() {
        if (this.inputFluid != null) {
            return this.inputFluid.amount;
        }
        return 0;
    }
}

