/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class IngredientItemFood
implements IIngredient<ItemStack> {
    private final IIngredient<ItemStack> innerIngredient;

    public IngredientItemFood(IIngredient<ItemStack> innerIngredient) {
        this.innerIngredient = innerIngredient;
    }

    @Override
    public NonNullList<ItemStack> getValidIngredients() {
        NonNullList<ItemStack> ingredients = this.innerIngredient.getValidIngredients();
        for (ItemStack stack : ingredients) {
            IFood food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
            if (food == null) continue;
            food.setNonDecaying();
        }
        return ingredients;
    }

    @Override
    public boolean test(ItemStack input) {
        return this.innerIngredient.test(input) && !this.isRotten(input);
    }

    @Override
    public boolean testIgnoreCount(ItemStack stack) {
        return this.innerIngredient.testIgnoreCount(stack) && !this.isRotten(stack);
    }

    @Override
    public ItemStack consume(ItemStack input) {
        return this.innerIngredient.consume(input);
    }

    private boolean isRotten(ItemStack stack) {
        IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        return cap != null && cap.isRotten();
    }
}

