/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class IngredientItemFoodTrait
implements IIngredient<ItemStack> {
    private final IIngredient<ItemStack> innerIngredient;
    private final FoodTrait trait;

    public IngredientItemFoodTrait(IIngredient<ItemStack> innerIngredient, FoodTrait trait) {
        this.innerIngredient = innerIngredient;
        this.trait = trait;
    }

    @Override
    public NonNullList<ItemStack> getValidIngredients() {
        NonNullList<ItemStack> ingredients = this.innerIngredient.getValidIngredients();
        for (ItemStack stack : ingredients) {
            IFood food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
            if (food == null) continue;
            CapabilityFood.applyTrait(food, this.trait);
        }
        return ingredients;
    }

    @Override
    public boolean test(ItemStack input) {
        return this.innerIngredient.test(input) && this.hasTrait(input);
    }

    @Override
    public boolean testIgnoreCount(ItemStack stack) {
        return this.innerIngredient.testIgnoreCount(stack) && this.hasTrait(stack);
    }

    @Override
    public ItemStack consume(ItemStack input) {
        return this.innerIngredient.consume(input);
    }

    private boolean hasTrait(ItemStack stack) {
        IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        return cap != null && cap.getTraits().contains(this.trait);
    }
}

