/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class IngredientMultipleFluidStack
implements IIngredient<FluidStack> {
    private final int amount;
    private final Fluid[] fluids;

    IngredientMultipleFluidStack(int amount, Fluid ... fluids) {
        this.amount = amount;
        this.fluids = fluids;
    }

    @Override
    public NonNullList<FluidStack> getValidIngredients() {
        NonNullList output = NonNullList.func_191196_a();
        for (Fluid fluid : this.fluids) {
            FluidStack out = new FluidStack(fluid, this.amount);
            output.add((Object)out);
        }
        return output;
    }

    @Override
    public boolean test(FluidStack input) {
        return this.testIgnoreCount(input) && input.amount >= this.amount;
    }

    @Override
    public boolean testIgnoreCount(FluidStack input) {
        if (input != null && input.getFluid() != null) {
            for (Fluid fluid : this.fluids) {
                if (fluid != input.getFluid()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public FluidStack consume(FluidStack input) {
        if (input.amount > this.amount) {
            return new FluidStack(input.getFluid(), input.amount - this.amount);
        }
        return null;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }
}

