/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.ceramics;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.ISmallVesselHandler;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.container.CapabilityContainerListener;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.inventory.capability.ISlotCallback;
import net.dries007.tfc.objects.inventory.slot.SlotCallback;
import net.dries007.tfc.objects.items.ceramics.ItemPottery;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class ItemSmallVessel
extends ItemPottery {
    private final boolean glazed;

    public ItemSmallVessel(boolean glazed) {
        this.glazed = glazed;
        this.func_77627_a(glazed);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        IFluidHandler cap;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && !playerIn.func_70093_af() && (cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) instanceof ISmallVesselHandler) {
            ISmallVesselHandler.Mode mode = ((ISmallVesselHandler)cap).getFluidMode();
            switch (mode) {
                case INVENTORY: {
                    TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.SMALL_VESSEL);
                    break;
                }
                case LIQUID_MOLTEN: {
                    TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.SMALL_VESSEL_LIQUID);
                    break;
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        if (!this.glazed) {
            return super.func_77667_c(stack);
        }
        return super.func_77667_c(stack) + "." + EnumDyeColor.func_176766_a((int)stack.func_77952_i()).func_176610_l();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            if (!this.glazed) {
                items.add((Object)new ItemStack((Item)this));
            } else {
                for (EnumDyeColor color : EnumDyeColor.values()) {
                    items.add((Object)new ItemStack((Item)this, 1, color.func_176767_b()));
                }
            }
        }
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return CapabilityContainerListener.readShareTag(stack);
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityContainerListener.applyShareTag(stack, nbt);
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Nonnull
    public ItemStack getFiringResult(ItemStack input) {
        IItemHandler capItemHandler = (IItemHandler)input.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (capItemHandler instanceof ISmallVesselHandler) {
            ISmallVesselHandler cap = (ISmallVesselHandler)capItemHandler;
            Alloy alloy = new Alloy();
            for (int i = 0; i < cap.getSlots(); ++i) {
                alloy.add(cap.getStackInSlot(i), Metal.Tier.TIER_VI, 1600.0f);
                cap.setStackInSlot(i, ItemStack.field_190927_a);
            }
            cap.setFluidMode(true);
            cap.fill(new FluidStack(FluidsTFC.getFluidFromMetal(alloy.getResult()), alloy.getAmount()), true);
            cap.setTemperature(1600.0f);
        }
        return input;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.NORMAL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new SmallVesselCapability(nbt);
    }

    private class SmallVesselCapability
    extends ItemStackHandler
    implements ICapabilityProvider,
    ISmallVesselHandler,
    ISlotCallback {
        private final FluidTank tank;
        private float heatCapacity;
        private float meltTemp;
        private float temperature;
        private long lastUpdateTick;
        private boolean fluidMode;
        private IFluidTankProperties[] fluidTankProperties;

        SmallVesselCapability(NBTTagCompound nbt) {
            super(4);
            this.tank = new FluidTank(ConfigTFC.Devices.SMALL_VESSEL.tank);
            this.fluidMode = false;
            this.deserializeNBT(nbt);
        }

        @Override
        public ISmallVesselHandler.Mode getFluidMode() {
            if (this.fluidMode) {
                return this.getTemperature() < this.meltTemp ? ISmallVesselHandler.Mode.LIQUID_SOLID : ISmallVesselHandler.Mode.LIQUID_MOLTEN;
            }
            return ISmallVesselHandler.Mode.INVENTORY;
        }

        @Override
        public void setFluidMode(boolean fluidMode) {
            this.fluidMode = fluidMode;
        }

        @Override
        public float getTemperature() {
            return CapabilityItemHeat.adjustTemp(this.temperature, this.heatCapacity, CalendarTFC.PLAYER_TIME.getTicks() - this.lastUpdateTick);
        }

        @Override
        public void setTemperature(float temperature) {
            this.temperature = temperature;
            this.lastUpdateTick = CalendarTFC.PLAYER_TIME.getTicks();
        }

        @Override
        public float getHeatCapacity() {
            return this.heatCapacity;
        }

        @Override
        public float getMeltTemp() {
            return this.meltTemp;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
            Metal metal = this.getMetal();
            if (metal != null) {
                String desc = TextFormatting.DARK_GREEN + I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{this.getAmount()});
                desc = this.isMolten() ? desc + I18n.func_135052_a((String)"tfc.tooltip.liquid", (Object[])new Object[0]) : desc + I18n.func_135052_a((String)"tfc.tooltip.solid", (Object[])new Object[0]);
                text.add(desc);
            } else {
                boolean hasContent = false;
                for (ItemStack slot : this.stacks) {
                    if (slot.func_190926_b()) continue;
                    text.add(1, I18n.func_135052_a((String)"tfc.tooltip.small_vessel_item", (Object[])new Object[]{slot.func_190916_E(), slot.func_77973_b().func_77653_i(slot)}));
                    hasContent = true;
                }
                if (!hasContent) {
                    text.add(1, I18n.func_135052_a((String)"tfc.tooltip.small_vessel_empty", (Object[])new Object[0]));
                }
            }
            ISmallVesselHandler.super.addHeatInfo(stack, text);
        }

        @Override
        @Nullable
        public Metal getMetal() {
            return this.fluidMode && this.tank.getFluid() != null ? FluidsTFC.getMetalFromFluid(this.tank.getFluid().getFluid()) : null;
        }

        @Override
        public int getAmount() {
            return this.fluidMode ? this.tank.getFluidAmount() : 0;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityItemHeat.ITEM_HEAT_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? this : null);
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.fluidTankProperties == null) {
                this.fluidTankProperties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(this.tank)};
            }
            return this.fluidTankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if ((this.fluidMode || this.isInventoryEmpty()) && resource != null) {
                this.updateFluidData(resource);
                this.fluidMode = true;
                return this.tank.fill(resource, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.getFluidMode() == ISmallVesselHandler.Mode.LIQUID_MOLTEN) {
                return this.tank.drain(resource, doDrain);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.getFluidMode() == ISmallVesselHandler.Mode.LIQUID_MOLTEN) {
                return this.tank.drain(maxDrain, doDrain);
            }
            return null;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
            if (cap != null) {
                CapabilityFood.applyTrait(cap, FoodTrait.PRESERVED);
            }
            super.setStackInSlot(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            IFood cap;
            if (!simulate && (cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null)) != null) {
                CapabilityFood.applyTrait(cap, FoodTrait.PRESERVED);
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            IFood cap = (IFood)this.getStackInSlot(slot).getCapability(CapabilityFood.CAPABILITY, null);
            if (cap != null) {
                CapabilityFood.removeTrait(cap, FoodTrait.PRESERVED);
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            IItemSize size = CapabilityItemSize.getIItemSize(stack);
            if (size != null) {
                return size.getSize(stack).isSmallerThan(Size.NORMAL);
            }
            return false;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.fluidMode = this.tank.getFluidAmount() > 0;
            nbt.func_74757_a("fluidMode", this.fluidMode);
            if (this.getTemperature() <= 0.0f) {
                nbt.func_74772_a("ticks", -1L);
                nbt.func_74776_a("heat", 0.0f);
            } else {
                nbt.func_74772_a("ticks", this.lastUpdateTick);
                nbt.func_74776_a("heat", this.temperature);
            }
            if (this.fluidMode) {
                NBTTagCompound fluidData = new NBTTagCompound();
                this.tank.writeToNBT(fluidData);
                nbt.func_74782_a("fluids", (NBTBase)fluidData);
            } else {
                nbt.func_74782_a("items", (NBTBase)super.serializeNBT());
            }
            return nbt;
        }

        public void deserializeNBT(@Nullable NBTTagCompound nbt) {
            if (nbt != null) {
                this.temperature = nbt.func_74760_g("heat");
                this.lastUpdateTick = nbt.func_74763_f("ticks");
                this.fluidMode = nbt.func_74767_n("fluidMode");
                if (this.fluidMode && nbt.func_150297_b("fluids", 10)) {
                    this.tank.readFromNBT(nbt.func_74775_l("fluids"));
                } else if (!this.fluidMode && nbt.func_150297_b("items", 10)) {
                    super.deserializeNBT(nbt.func_74775_l("items"));
                }
            }
            this.updateFluidData(this.tank.getFluid());
        }

        @Override
        public void beforePutStack(SlotCallback slot, @Nonnull ItemStack stack) {
            IFood cap = (IFood)slot.func_75211_c().getCapability(CapabilityFood.CAPABILITY, null);
            if (cap != null) {
                CapabilityFood.removeTrait(cap, FoodTrait.PRESERVED);
            }
        }

        private void updateFluidData(@Nullable FluidStack fluid) {
            Metal metal;
            this.meltTemp = 1000.0f;
            this.heatCapacity = 1.0f;
            if (fluid != null && (metal = FluidsTFC.getMetalFromFluid(fluid.getFluid())) != null) {
                this.meltTemp = metal.getMeltTemp();
                this.heatCapacity = metal.getSpecificHeat();
            }
        }

        private boolean isInventoryEmpty() {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }
    }
}

