/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.blocks.metal.BlockTrapDoorMetalTFC;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockMetalLamp;
import net.dries007.tfc.objects.items.metal.ItemMetalSword;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@ParametersAreNonnullByDefault
public class ItemMetal
extends ItemTFC
implements IMetalItem {
    private static final Map<Metal, EnumMap<Metal.ItemType, ItemMetal>> TABLE = new HashMap<Metal, EnumMap<Metal.ItemType, ItemMetal>>();
    protected final Metal metal;
    protected final Metal.ItemType type;

    public static Item get(Metal metal, Metal.ItemType type) {
        if (type == Metal.ItemType.SWORD) {
            return ItemMetalSword.get(metal);
        }
        if (type == Metal.ItemType.LAMP) {
            return ItemBlockMetalLamp.get(metal);
        }
        if (type == Metal.ItemType.TRAPDOOR) {
            return ItemBlock.func_150898_a((Block)BlockTrapDoorMetalTFC.get(metal));
        }
        return TABLE.get((Object)metal).get((Object)type);
    }

    public ItemMetal(Metal metal, Metal.ItemType type) {
        this.metal = metal;
        this.type = type;
        if (!TABLE.containsKey((Object)metal)) {
            TABLE.put(metal, new EnumMap(Metal.ItemType.class));
        }
        TABLE.get((Object)metal).put(type, this);
        this.setNoRepair();
        if (type == Metal.ItemType.DOUBLE_INGOT) {
            OreDictionaryHelper.register(this, "ingot", "double", metal.getRegistryName().func_110623_a());
            if (metal == Metal.BRONZE || metal == Metal.BISMUTH_BRONZE || metal == Metal.BLACK_BRONZE) {
                OreDictionaryHelper.register(this, "ingot", "double", "Any", "Bronze");
            }
            if (metal == Metal.WROUGHT_IRON && ConfigTFC.General.MISC.dictionaryIron) {
                OreDictionaryHelper.register(this, "ingot", "double", "Iron");
            }
        } else if (type == Metal.ItemType.DOUBLE_SHEET) {
            OreDictionaryHelper.register(this, "sheet", "double", metal.getRegistryName().func_110623_a());
            if (metal == Metal.BRONZE || metal == Metal.BISMUTH_BRONZE || metal == Metal.BLACK_BRONZE) {
                OreDictionaryHelper.register(this, "sheet", "double", "Any", "Bronze");
            }
            if (metal == Metal.WROUGHT_IRON && ConfigTFC.General.MISC.dictionaryIron) {
                OreDictionaryHelper.register(this, "sheet", "double", "Iron");
            }
        } else if (type.isToolItem()) {
            OreDictionaryHelper.register(this, new Object[]{type});
        } else {
            OreDictionaryHelper.register(this, new Object[]{type, metal.getRegistryName().func_110623_a()});
            if (metal == Metal.BRONZE || metal == Metal.BISMUTH_BRONZE || metal == Metal.BLACK_BRONZE) {
                OreDictionaryHelper.register(this, new Object[]{type, "Any", "Bronze"});
            }
            if (type == Metal.ItemType.SHEET && ConfigTFC.General.MISC.dictionaryPlates) {
                OreDictionaryHelper.register(this, new Object[]{"plate", metal});
            }
            if (metal == Metal.WROUGHT_IRON && ConfigTFC.General.MISC.dictionaryIron) {
                OreDictionaryHelper.register(this, new Object[]{type, "Iron"});
                if (type == Metal.ItemType.SHEET && ConfigTFC.General.MISC.dictionaryPlates) {
                    OreDictionaryHelper.register(this, "plate", "Iron");
                }
            }
        }
        if (type == Metal.ItemType.TUYERE) {
            this.func_77656_e(metal.getToolMetal() != null ? (int)((double)metal.getToolMetal().func_77997_a() * 0.2) : 100);
        }
    }

    @Override
    public Metal getMetal(ItemStack stack) {
        return this.metal;
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        if (!this.func_77645_m() || !stack.func_77951_h()) {
            return this.type.getSmeltAmount();
        }
        double d = (double)(stack.func_77958_k() - stack.func_77952_i()) / (double)stack.func_77958_k() - 0.1;
        return d < 0.0 ? 0 : MathHelper.func_76128_c((double)((double)this.type.getSmeltAmount() * d));
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        switch (this.type) {
            case NUGGET: 
            case DUST: 
            case SCRAP: {
                return Size.SMALL;
            }
            case PICK_HEAD: 
            case HAMMER_HEAD: 
            case HOE_HEAD: 
            case AXE_HEAD: 
            case CHISEL_HEAD: 
            case JAVELIN_HEAD: 
            case MACE_HEAD: 
            case PROPICK_HEAD: 
            case SHOVEL_HEAD: 
            case KNIFE_BLADE: 
            case SAW_BLADE: 
            case SCYTHE_BLADE: 
            case SWORD_BLADE: {
                return Size.NORMAL;
            }
            case ANVIL: {
                return Size.HUGE;
            }
        }
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        switch (this.type) {
            case NUGGET: 
            case DUST: 
            case SCRAP: {
                return Weight.VERY_LIGHT;
            }
            case INGOT: 
            case DOUBLE_INGOT: 
            case SHEET: 
            case DOUBLE_SHEET: {
                return Weight.LIGHT;
            }
            case ANVIL: 
            case HELMET: 
            case GREAVES: 
            case CHESTPLATE: 
            case BOOTS: 
            case UNFINISHED_CHESTPLATE: 
            case UNFINISHED_GREAVES: 
            case UNFINISHED_HELMET: 
            case UNFINISHED_BOOTS: {
                return Weight.VERY_HEAVY;
            }
        }
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(@Nonnull ItemStack stack) {
        switch (this.type) {
            case NUGGET: 
            case DUST: 
            case SCRAP: 
            case PICK_HEAD: 
            case HAMMER_HEAD: 
            case HOE_HEAD: 
            case AXE_HEAD: 
            case CHISEL_HEAD: 
            case JAVELIN_HEAD: 
            case MACE_HEAD: 
            case PROPICK_HEAD: 
            case SHOVEL_HEAD: 
            case KNIFE_BLADE: 
            case SAW_BLADE: 
            case SCYTHE_BLADE: 
            case SWORD_BLADE: 
            case ANVIL: 
            case INGOT: 
            case DOUBLE_INGOT: 
            case SHEET: 
            case DOUBLE_SHEET: 
            case ROD: 
            case LAMP: 
            case TRAPDOOR: {
                return true;
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.type == Metal.ItemType.KNIFE || super.doesSneakBypassUse(stack, world, pos, player);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ForgeableHeatableHandler(nbt, this.metal.getSpecificHeat(), this.metal.getMeltTemp());
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        switch (this.metal.getTier()) {
            case TIER_I: 
            case TIER_II: {
                return EnumRarity.COMMON;
            }
            case TIER_III: {
                return EnumRarity.UNCOMMON;
            }
            case TIER_IV: {
                return EnumRarity.RARE;
            }
            case TIER_V: {
                return EnumRarity.EPIC;
            }
        }
        return super.getForgeRarity(stack);
    }

    public Metal.ItemType getType() {
        return this.type;
    }
}

