/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemMetalTool
extends ItemMetal {
    public final Item.ToolMaterial material;
    private final double attackDamage;
    private final int areaOfEffect;
    private final float attackSpeed;
    private float efficiency;

    public ItemMetalTool(Metal metal, Metal.ItemType type) {
        super(metal, type);
        float typeDamage;
        if (metal.getToolMetal() == null) {
            throw new IllegalArgumentException("You can't make tools out of non tool metals.");
        }
        this.material = metal.getToolMetal();
        int harvestLevel = this.material.func_77996_d();
        this.func_77625_d(1);
        this.func_77656_e(this.material.func_77997_a());
        this.efficiency = this.material.func_77998_b();
        switch (type) {
            case PICK: {
                this.setHarvestLevel("pickaxe", harvestLevel);
                typeDamage = 0.75f;
                this.areaOfEffect = 1;
                this.attackSpeed = -2.8f;
                OreDictionaryHelper.registerDamageType(this, DamageType.PIERCING);
                break;
            }
            case SHOVEL: {
                this.setHarvestLevel("shovel", harvestLevel);
                typeDamage = 0.875f;
                this.areaOfEffect = 1;
                this.attackSpeed = -3.0f;
                OreDictionaryHelper.registerDamageType(this, DamageType.CRUSHING);
                break;
            }
            case AXE: {
                this.setHarvestLevel("axe", harvestLevel);
                typeDamage = 1.5f;
                this.areaOfEffect = 1;
                this.attackSpeed = -3.0f;
                OreDictionaryHelper.registerDamageType(this, DamageType.SLASHING);
                break;
            }
            case HOE: {
                this.setHarvestLevel("hoe", harvestLevel);
                typeDamage = 0.875f;
                this.areaOfEffect = 1;
                this.attackSpeed = -3.0f;
                OreDictionaryHelper.registerDamageType(this, DamageType.PIERCING);
                break;
            }
            case CHISEL: {
                this.setHarvestLevel("chisel", harvestLevel);
                typeDamage = 0.27f;
                this.areaOfEffect = 1;
                this.attackSpeed = -1.5f;
                OreDictionaryHelper.registerDamageType(this, DamageType.SLASHING);
                break;
            }
            case SAW: {
                this.setHarvestLevel("axe", harvestLevel);
                this.setHarvestLevel("saw", harvestLevel);
                typeDamage = 0.5f;
                this.areaOfEffect = 1;
                this.attackSpeed = -3.0f;
                OreDictionaryHelper.registerDamageType(this, DamageType.SLASHING);
                break;
            }
            case PROPICK: {
                typeDamage = 0.5f;
                this.areaOfEffect = 1;
                this.attackSpeed = -2.8f;
                this.func_77656_e(this.material.func_77997_a() / 3);
                this.efficiency = this.material.func_77998_b() * 0.5f;
                OreDictionaryHelper.registerDamageType(this, DamageType.PIERCING);
                break;
            }
            case SCYTHE: {
                this.setHarvestLevel("scythe", harvestLevel);
                this.func_77656_e((int)((double)this.material.func_77997_a() * 1.5));
                typeDamage = 2.0f;
                this.areaOfEffect = 2;
                this.attackSpeed = -3.2f;
                OreDictionaryHelper.registerDamageType(this, DamageType.PIERCING);
                break;
            }
            case SHEARS: {
                this.setHarvestLevel("shears", harvestLevel);
                this.func_77656_e((int)((double)this.material.func_77997_a() * 0.3));
                typeDamage = 0.2f;
                this.areaOfEffect = 1;
                this.attackSpeed = -2.8f;
                OreDictionaryHelper.registerDamageType(this, DamageType.CRUSHING);
                break;
            }
            case KNIFE: {
                this.setHarvestLevel("knife", harvestLevel);
                typeDamage = 0.54f;
                this.areaOfEffect = 1;
                this.attackSpeed = -1.5f;
                OreDictionaryHelper.registerDamageType(this, DamageType.PIERCING);
                break;
            }
            case HAMMER: {
                this.setHarvestLevel("hammer", harvestLevel);
                typeDamage = 1.0f;
                this.areaOfEffect = 1;
                this.attackSpeed = -3.0f;
                OreDictionaryHelper.registerDamageType(this, DamageType.CRUSHING);
                break;
            }
            case SWORD: {
                typeDamage = 1.0f;
                this.areaOfEffect = 1;
                this.attackSpeed = -2.4f;
                OreDictionaryHelper.registerDamageType(this, DamageType.SLASHING);
                break;
            }
            case MACE: {
                typeDamage = 1.3f;
                this.areaOfEffect = 1;
                this.attackSpeed = -2.8f;
                OreDictionaryHelper.registerDamageType(this, DamageType.CRUSHING);
                break;
            }
            case JAVELIN: {
                typeDamage = 0.7f;
                this.areaOfEffect = 1;
                this.attackSpeed = -1.8f;
                OreDictionaryHelper.registerDamageType(this, DamageType.PIERCING);
                break;
            }
            case SHIELD: {
                typeDamage = 0.1f;
                this.areaOfEffect = 1;
                this.attackSpeed = -3.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Tool from non tool type.");
            }
        }
        this.attackDamage = typeDamage * this.material.func_78000_c();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        if (this.type == Metal.ItemType.SHOVEL) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (!(block instanceof BlockRockVariant)) {
                return EnumActionResult.PASS;
            }
            BlockRockVariant rockVariant = (BlockRockVariant)block;
            if (ConfigTFC.General.OVERRIDES.enableGrassPath && facing != EnumFacing.DOWN && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && rockVariant.getType() == Rock.Type.GRASS || rockVariant.getType() == Rock.Type.DRY_GRASS || rockVariant.getType() == Rock.Type.DIRT) {
                IBlockState iblockstate1 = BlockRockVariant.get(rockVariant.getRock(), Rock.Type.PATH).func_176223_P();
                worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!worldIn.field_72995_K) {
                    worldIn.func_180501_a(pos, iblockstate1, 11);
                    itemstack.func_77972_a(1, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.canHarvestBlock(state, stack) ? this.efficiency : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        switch (this.type) {
            case SAW: 
            case PROPICK: 
            case SHEARS: {
                stack.func_77972_a(4, attacker);
                break;
            }
            case HOE: 
            case CHISEL: {
                stack.func_77972_a(3, attacker);
                break;
            }
            case PICK: 
            case SHOVEL: 
            case AXE: 
            case SCYTHE: {
                stack.func_77972_a(2, attacker);
                break;
            }
            case KNIFE: 
            case HAMMER: 
            case SWORD: 
            case MACE: 
            case JAVELIN: {
                stack.func_77972_a(1, attacker);
            }
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((state.func_185887_b(worldIn, pos) > 0.0f || this.type == Metal.ItemType.KNIFE || this.type == Metal.ItemType.SCYTHE) && !worldIn.field_72995_K) {
            stack.func_77972_a(1, entityLiving);
        }
        if (this.areaOfEffect > 1 && entityLiving instanceof EntityPlayer && !worldIn.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int areaPlus = this.areaOfEffect - 1;
            for (BlockPos.MutableBlockPos extraPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-areaPlus, -areaPlus, -areaPlus), (BlockPos)pos.func_177982_a(areaPlus, areaPlus, areaPlus))) {
                IBlockState st = worldIn.func_180495_p((BlockPos)extraPos);
                if (extraPos.equals((Object)pos) || worldIn.func_175623_d((BlockPos)extraPos) || !this.func_150897_b(st)) continue;
                st.func_177230_c().func_176206_d(worldIn, (BlockPos)extraPos, st);
                st.func_177230_c().func_180657_a(worldIn, player, (BlockPos)extraPos, st, worldIn.func_175625_s((BlockPos)extraPos), stack);
                worldIn.func_175698_g((BlockPos)extraPos);
                stack.func_77972_a(1, entityLiving);
            }
        }
        return true;
    }

    public boolean func_150897_b(IBlockState state) {
        Material material = state.func_185904_a();
        switch (this.type) {
            case AXE: {
                return material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l;
            }
            case PICK: {
                return material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e;
            }
            case SHOVEL: {
                return material == Material.field_151597_y || material == Material.field_151596_z;
            }
            case SCYTHE: {
                return material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151584_j;
            }
            case KNIFE: {
                return material == Material.field_151582_l || material == Material.field_151584_j;
            }
            case SWORD: {
                return material == Material.field_151569_G;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        switch (this.type) {
            case SWORD: 
            case MACE: 
            case JAVELIN: {
                return false;
            }
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return this.func_150897_b(state);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        if (enchantment.field_77351_y == EnumEnchantmentType.WEAPON) {
            return this.isWeapon();
        }
        if (enchantment.field_77351_y == EnumEnchantmentType.DIGGER) {
            return this.isTool();
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    private boolean isWeapon() {
        switch (this.type) {
            case AXE: 
            case KNIFE: 
            case HAMMER: 
            case SWORD: 
            case MACE: 
            case JAVELIN: {
                return true;
            }
        }
        return false;
    }

    private boolean isTool() {
        switch (this.type) {
            case PICK: 
            case SHOVEL: 
            case AXE: 
            case HOE: 
            case CHISEL: 
            case SAW: 
            case PROPICK: 
            case SCYTHE: 
            case SHEARS: 
            case KNIFE: 
            case HAMMER: {
                return true;
            }
        }
        return false;
    }
}

