/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRock
extends ItemTFC
implements IRockObject {
    private static final Map<Rock, ItemRock> MAP = new HashMap<Rock, ItemRock>();
    private final Rock rock;

    public static ItemRock get(Rock rock) {
        return MAP.get((Object)rock);
    }

    public static ItemStack get(Rock rock, int amount) {
        return new ItemStack((Item)MAP.get((Object)rock), amount);
    }

    public ItemRock(Rock rock) {
        this.rock = rock;
        if (MAP.put(rock, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e(0);
        OreDictionaryHelper.register(this, "rock");
        OreDictionaryHelper.register(this, new Object[]{"rock", rock});
        OreDictionaryHelper.register(this, new Object[]{"rock", rock.getRockCategory()});
        if (rock.isFluxStone()) {
            OreDictionaryHelper.register(this, "rock", "flux");
        }
    }

    @Override
    @Nonnull
    public Rock getRock(ItemStack stack) {
        return this.rock;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.rock.getRockCategory();
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_LIGHT;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !player.func_70093_af() && stack.func_190916_E() > 1) {
            TFCGuiHandler.openGui(world, player.func_180425_c(), player, TFCGuiHandler.Type.KNAPPING_STONE);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

