/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemRockHammer
extends ItemTool
implements IItemSize,
IRockObject {
    private static final Map<RockCategory, ItemRockHammer> MAP = new HashMap<RockCategory, ItemRockHammer>();
    public final RockCategory category;

    public static ItemRockHammer get(RockCategory category) {
        return MAP.get((Object)category);
    }

    public ItemRockHammer(RockCategory category) {
        super(0.0f, -3.0f, category.getToolMaterial(), (Set)ImmutableSet.of());
        this.category = category;
        if (MAP.put(category, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.setHarvestLevel("hammer", category.getToolMaterial().func_77996_d());
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.CRUSHING);
        OreDictionaryHelper.register((Item)this, "hammer");
        OreDictionaryHelper.register((Item)this, "hammer", "stone");
        OreDictionaryHelper.register((Item)this, new Object[]{"hammer", "stone", category});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rock type: " + OreDictionaryHelper.toString(new Object[]{this.category}));
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Rock getRock(ItemStack stack) {
        return null;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.category;
    }
}

