/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRockHoe
extends ItemHoe
implements IItemSize,
IRockObject {
    private static final Map<RockCategory, ItemRockHoe> MAP = new HashMap<RockCategory, ItemRockHoe>();
    public final RockCategory category;
    private final float attackDamage;

    public static ItemRockHoe get(RockCategory category) {
        return MAP.get((Object)category);
    }

    public ItemRockHoe(RockCategory category) {
        super(category.getToolMaterial());
        this.category = category;
        if (MAP.put(category, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.setHarvestLevel("hoe", category.getToolMaterial().func_77996_d());
        OreDictionaryHelper.register((Item)this, "hoe");
        OreDictionaryHelper.register((Item)this, "hoe", "stone");
        OreDictionaryHelper.register((Item)this, new Object[]{"hoe", "stone", category});
        this.attackDamage = category.getToolMaterial().func_78000_c() * 0.875f;
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.PIERCING);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rock type: " + OreDictionaryHelper.toString(new Object[]{this.category}));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        }
        return multimap;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.LIGHT;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Rock getRock(ItemStack stack) {
        return null;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.category;
    }
}

