/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class ItemRockShovel
extends ItemSpade
implements IItemSize,
IRockObject {
    private static final Map<RockCategory, ItemRockShovel> MAP = new HashMap<RockCategory, ItemRockShovel>();
    public final RockCategory category;

    public static ItemRockShovel get(RockCategory category) {
        return MAP.get((Object)category);
    }

    public ItemRockShovel(RockCategory category) {
        super(category.getToolMaterial());
        this.category = category;
        if (MAP.put(category, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.field_77865_bY = 0.875f * category.getToolMaterial().func_78000_c();
        this.field_185065_c = -3.0f;
        this.setHarvestLevel("shovel", category.getToolMaterial().func_77996_d());
        OreDictionaryHelper.register((Item)this, "shovel");
        OreDictionaryHelper.register((Item)this, "shovel", "stone");
        OreDictionaryHelper.register((Item)this, new Object[]{"shovel", "stone", category});
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.CRUSHING);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rock type: " + OreDictionaryHelper.toString(new Object[]{this.category}));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!(block instanceof BlockRockVariant)) {
            return EnumActionResult.PASS;
        }
        BlockRockVariant rockVariant = (BlockRockVariant)block;
        if (ConfigTFC.General.OVERRIDES.enableGrassPath && facing != EnumFacing.DOWN && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && rockVariant.getType() == Rock.Type.GRASS || rockVariant.getType() == Rock.Type.DRY_GRASS || rockVariant.getType() == Rock.Type.DIRT) {
            IBlockState iblockstate1 = BlockRockVariant.get(rockVariant.getRock(), Rock.Type.PATH).func_176223_P();
            worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, iblockstate1, 11);
                itemstack.func_77972_a(1, (EntityLivingBase)player);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Rock getRock(ItemStack stack) {
        return null;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.category;
    }
}

