/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class FoodStackingRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack foodStack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (!stack.hasCapability(CapabilityFood.CAPABILITY, null)) {
                return false;
            }
            if (foodStack.func_190926_b()) {
                foodStack = stack;
                continue;
            }
            if (CapabilityFood.areStacksStackableExceptCreationDate(stack, foodStack)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack resultStack = ItemStack.field_190927_a;
        int outputAmount = 0;
        long minCreationDate = -1L;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            IFood cap;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || (cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null)) == null) continue;
            ++outputAmount;
            if (minCreationDate == -1L || minCreationDate > cap.getCreationDate()) {
                minCreationDate = cap.getCreationDate();
            }
            if (!resultStack.func_190926_b()) continue;
            resultStack = stack.func_77946_l();
        }
        resultStack.func_190920_e(outputAmount);
        IFood cap = (IFood)resultStack.getCapability(CapabilityFood.CAPABILITY, null);
        if (cap != null) {
            cap.setCreationDate(minCreationDate);
        }
        return resultStack;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return new FoodStackingRecipe();
        }
    }
}

