/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.dries007.tfc.objects.recipes.ShapelessDamageRecipe;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class ShapelessDamageFoodRecipe
extends ShapelessDamageRecipe {
    private ShapelessDamageFoodRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, int damage) {
        super(group, input, result, damage);
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack out = this.output.func_77946_l();
        long smallestRottenDate = -1L;
        ItemStack foodStack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            IFood foodCap;
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b() || (foodCap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null)) == null || smallestRottenDate != -1L && smallestRottenDate <= foodCap.getRottenDate()) continue;
            smallestRottenDate = foodCap.getRottenDate();
            foodStack = stack;
        }
        return foodStack != null ? CapabilityFood.updateFoodFromPrevious(foodStack, out) : ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        EntityPlayer player = ForgeHooks.getCraftingPlayer();
        if (player != null && !player.field_70170_p.field_72995_K && OreDictionaryHelper.doesStackMatchOre(this.output, "grain")) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Item)ItemsTFC.STRAW));
        }
        return super.func_179532_b(inventoryCrafting);
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtils.parseShapeless(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            int damage = JsonUtils.func_151204_g((JsonObject)json, (String)"damage") ? JsonUtils.func_151203_m((JsonObject)json, (String)"damage") : 1;
            return new ShapelessDamageFoodRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients, result, damage);
        }
    }
}

