/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.recipes.WeldingRecipe;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.metal.BlockAnvilTFC;
import net.dries007.tfc.objects.blocks.stone.BlockStoneAnvil;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.forge.ForgeStep;
import net.dries007.tfc.util.forge.ForgeSteps;
import net.dries007.tfc.util.skills.SkillType;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class TEAnvilTFC
extends TEInventory {
    public static final int WORK_MAX = 145;
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_INPUT_2 = 1;
    public static final int SLOT_HAMMER = 2;
    public static final int SLOT_FLUX = 3;
    private AnvilRecipe recipe = null;
    private ForgeSteps steps = new ForgeSteps();
    private int workingProgress = 0;
    private int workingTarget = 0;

    public TEAnvilTFC() {
        super(4);
    }

    public boolean isStone() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockStoneAnvil;
    }

    @Nonnull
    public Metal.Tier getTier() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockAnvilTFC) {
            return ((BlockAnvilTFC)state.func_177230_c()).getMetal().getTier();
        }
        return Metal.Tier.TIER_0;
    }

    @Nullable
    public AnvilRecipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public ForgeSteps getSteps() {
        return this.steps;
    }

    public boolean setRecipe(@Nullable AnvilRecipe recipe) {
        boolean recipeChanged;
        ItemStack stack = this.inventory.getStackInSlot(0);
        IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap != null && recipe != null) {
            recipeChanged = this.recipe != recipe;
            cap.setRecipe(recipe);
            this.recipe = recipe;
            this.workingProgress = cap.getWork();
            this.steps = cap.getSteps().copy();
            this.workingTarget = recipe.getTarget(this.field_145850_b.func_72905_C());
        } else {
            recipeChanged = this.recipe != null;
            this.recipe = null;
            if (cap != null) {
                cap.reset();
            }
            this.resetFields();
        }
        return recipeChanged;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (!this.field_145850_b.field_72995_K && this.checkRecipeUpdate()) {
            this.markForSync();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        String recipe = nbt.func_74779_i("recipe");
        this.recipe = StringUtils.func_151246_b((String)recipe) ? null : (AnvilRecipe)TFCRegistries.ANVIL.getValue(new ResourceLocation(recipe));
        this.steps.deserializeNBT(nbt.func_74775_l("steps"));
        this.workingProgress = nbt.func_74762_e("work");
        this.workingTarget = nbt.func_74762_e("target");
        super.func_145839_a(nbt);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("recipe", this.recipe.getRegistryName().toString());
        }
        nbt.func_74782_a("steps", (NBTBase)this.steps.serializeNBT());
        nbt.func_74768_a("work", this.workingProgress);
        nbt.func_74768_a("target", this.workingTarget);
        return super.func_189515_b(nbt);
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot == 3 ? super.getSlotLimit(slot) : 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: 
            case 1: {
                return stack.hasCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
            }
            case 3: {
                return OreDictionaryHelper.doesStackMatchOre(stack, "dustFlux");
            }
            case 2: {
                return OreDictionaryHelper.doesStackMatchOre(stack, "hammer");
            }
        }
        return false;
    }

    public void addStep(@Nonnull EntityPlayer player, @Nullable ForgeStep step) {
        ItemStack input = this.inventory.getStackInSlot(0);
        IForgeable cap = (IForgeable)input.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap != null) {
            if (step != null) {
                if (!cap.getSteps().hasWork() && step.getStepAmount() < 0) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_safety", new Object[0]), false);
                } else {
                    cap.addStep(step);
                    this.steps = cap.getSteps().copy();
                    this.workingProgress += step.getStepAmount();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, TFCSounds.ANVIL_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
            if (this.recipe != null) {
                AnvilRecipe completedRecipe = this.recipe;
                int workMin = this.workingTarget - ConfigTFC.General.DIFFICULTY.acceptableAnvilRange;
                int workMax = this.workingTarget + ConfigTFC.General.DIFFICULTY.acceptableAnvilRange;
                if (this.workingProgress <= workMax && this.workingProgress >= workMin && completedRecipe.matches(this.steps)) {
                    List<AnvilRecipe> recipes;
                    this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    SmithingSkill skill = CapabilityPlayerData.getSkill(player, SkillType.SMITHING);
                    if (skill != null && completedRecipe.getSkillBonusType() != null) {
                        skill.addSkill(completedRecipe.getSkillBonusType(), 1);
                    }
                    for (ItemStack output : completedRecipe.getOutput(input)) {
                        if (output.func_190926_b()) continue;
                        IItemHeat outputCap = (IItemHeat)output.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                        if (outputCap != null && cap instanceof IItemHeat) {
                            outputCap.setTemperature(((IItemHeat)((Object)cap)).getTemperature());
                        }
                        if (skill != null && completedRecipe.getSkillBonusType() != null) {
                            SmithingSkill.applySkillBonus(skill, output, completedRecipe.getSkillBonusType());
                        }
                        if (this.inventory.getStackInSlot(0).func_190926_b()) {
                            this.inventory.setStackInSlot(0, output);
                            continue;
                        }
                        if (this.inventory.getStackInSlot(1).func_190926_b()) {
                            this.inventory.setStackInSlot(1, output);
                            continue;
                        }
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)output);
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, TFCSounds.ANVIL_IMPACT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.resetFields();
                    AnvilRecipe newRecipe = null;
                    if (this.inventory.getStackInSlot(1).func_190926_b() && (recipes = AnvilRecipe.getAllFor(this.inventory.getStackInSlot(0))).size() == 1) {
                        newRecipe = recipes.get(0);
                    }
                    this.setRecipe(newRecipe);
                } else if (this.workingProgress < 0 || this.workingProgress > 145) {
                    this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
            this.markForSync();
        }
    }

    public boolean attemptWelding(EntityPlayer player) {
        ItemStack input1 = this.inventory.getStackInSlot(0);
        ItemStack input2 = this.inventory.getStackInSlot(1);
        if (input1.func_190926_b() || input2.func_190926_b()) {
            return false;
        }
        WeldingRecipe recipe = WeldingRecipe.get(input1, input2, this.getTier());
        if (recipe != null) {
            ItemStack fluxStack = this.inventory.getStackInSlot(3);
            if (fluxStack.func_190926_b()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_no_flux", new Object[0]));
                return false;
            }
            IForgeable cap1 = (IForgeable)input1.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
            IForgeable cap2 = (IForgeable)input2.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
            if (cap1 == null || cap2 == null || !cap1.isWeldable() || !cap2.isWeldable()) {
                if (cap1 instanceof IItemHeat && cap2 instanceof IItemHeat) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_too_cold", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.anvil_not_weldable", new Object[0]));
                }
                return false;
            }
            ItemStack result = recipe.getOutput(player);
            IItemHeat heatResult = (IItemHeat)result.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            float resultTemperature = 0.0f;
            if (cap1 instanceof IItemHeat) {
                resultTemperature = ((IItemHeat)((Object)cap1)).getTemperature();
            }
            if (cap2 instanceof IItemHeat) {
                resultTemperature = Math.min(resultTemperature, ((IItemHeat)((Object)cap2)).getTemperature());
            }
            if (heatResult != null) {
                heatResult.setTemperature(resultTemperature);
            }
            this.inventory.setStackInSlot(0, result);
            this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            this.inventory.setStackInSlot(3, Helpers.consumeItem(fluxStack, 1));
            return true;
        }
        return false;
    }

    public int getWorkingProgress() {
        return this.workingProgress;
    }

    public int getWorkingTarget() {
        return this.workingTarget;
    }

    private boolean checkRecipeUpdate() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        boolean shouldSendUpdate = false;
        if (cap == null && this.recipe != null) {
            shouldSendUpdate = this.setRecipe(null);
        } else if (cap != null) {
            AnvilRecipe capRecipe = (AnvilRecipe)TFCRegistries.ANVIL.getValue(cap.getRecipeName());
            if (capRecipe != this.recipe) {
                shouldSendUpdate = this.setRecipe(capRecipe);
            } else if (AnvilRecipe.getAllFor(stack).size() == 1) {
                shouldSendUpdate = this.setRecipe(AnvilRecipe.getAllFor(stack).get(0));
            }
        }
        return shouldSendUpdate;
    }

    private void resetFields() {
        this.workingProgress = 0;
        this.workingTarget = 0;
        this.steps.reset();
    }
}

