/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.api.util.IHeatConsumerBlock;
import net.dries007.tfc.objects.blocks.BlockMolten;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.devices.BlockBlastFurnace;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TECrucible;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.fuel.Fuel;
import net.dries007.tfc.util.fuel.FuelManager;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class TEBlastFurnace
extends TETickableInventory
implements ITickable,
ITileFields {
    public static final int SLOT_TUYERE = 0;
    public static final int FIELD_TEMPERATURE = 0;
    public static final int FIELD_ORE = 1;
    public static final int FIELD_FUEL = 2;
    public static final int FIELD_MELT = 3;
    public static final int FIELD_ORE_UNITS = 4;
    public static final int CHIMNEY_LEVELS = 5;
    private final List<ItemStack> oreStacks = new ArrayList<ItemStack>();
    private final List<ItemStack> fuelStacks = new ArrayList<ItemStack>();
    private final Alloy alloy;
    private int maxFuel = 0;
    private int maxOre = 0;
    private int delayTimer = 0;
    private int meltAmount = 0;
    private int chimney = 0;
    private long burnTicksLeft = 0L;
    private long airTicks = 0L;
    private int fuelCount = 0;
    private int oreCount = 0;
    private int oreUnits;
    private float temperature = 0.0f;
    private float burnTemperature = 0.0f;

    public TEBlastFurnace() {
        super(1);
        this.alloy = new Alloy(ConfigTFC.Devices.CRUCIBLE.tank);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return OreDictionaryHelper.doesStackMatchOre(stack, "tuyere");
    }

    public long getBurnTicksLeft() {
        return this.burnTicksLeft;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.oreStacks.clear();
        NBTTagList ores = nbt.func_150295_c("ores", 10);
        for (int i = 0; i < ores.func_74745_c(); ++i) {
            this.oreStacks.add(new ItemStack(ores.func_150305_b(i)));
        }
        this.fuelStacks.clear();
        NBTTagList fuels = nbt.func_150295_c("fuels", 10);
        for (int i = 0; i < fuels.func_74745_c(); ++i) {
            this.fuelStacks.add(new ItemStack(fuels.func_150305_b(i)));
        }
        this.burnTicksLeft = nbt.func_74763_f("burnTicksLeft");
        this.airTicks = nbt.func_74763_f("airTicks");
        this.burnTemperature = nbt.func_74760_g("burnTemperature");
        this.temperature = nbt.func_74760_g("temperature");
        this.alloy.deserializeNBT(nbt.func_74775_l("alloy"));
        super.func_145839_a(nbt);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList ores = new NBTTagList();
        for (ItemStack stack : this.oreStacks) {
            ores.func_74742_a((NBTBase)stack.serializeNBT());
        }
        nbt.func_74782_a("ores", (NBTBase)ores);
        NBTTagList fuels = new NBTTagList();
        for (ItemStack stack : this.fuelStacks) {
            fuels.func_74742_a((NBTBase)stack.serializeNBT());
        }
        nbt.func_74782_a("fuels", (NBTBase)fuels);
        nbt.func_74772_a("burnTicksLeft", this.burnTicksLeft);
        nbt.func_74772_a("airTicks", this.airTicks);
        nbt.func_74776_a("burnTemperature", this.burnTemperature);
        nbt.func_74776_a("temperature", this.temperature);
        nbt.func_74782_a("alloy", (NBTBase)this.alloy.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Override
    public void onBreakBlock(World worldIn, BlockPos pos, IBlockState state) {
        for (int i = 1; i < 6; ++i) {
            if (this.field_145850_b.func_180495_p(pos.func_177981_b(i)).func_177230_c() != BlocksTFC.MOLTEN) continue;
            this.field_145850_b.func_175698_g(pos.func_177981_b(i));
        }
        for (ItemStack stack : this.oreStacks) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177978_c().func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177978_c().func_177952_p(), (ItemStack)stack);
        }
        for (ItemStack stack : this.fuelStacks) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177978_c().func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177978_c().func_177952_p(), (ItemStack)stack);
        }
        super.onBreakBlock(this.field_145850_b, pos, state);
    }

    public ImmutableList<ItemStack> getFuelStacks() {
        return ImmutableList.copyOf(this.fuelStacks);
    }

    public ImmutableList<ItemStack> getOreStacks() {
        return ImmutableList.copyOf(this.oreStacks);
    }

    public boolean canIgnite() {
        if (!this.field_145850_b.field_72995_K) {
            return !this.fuelStacks.isEmpty() && !this.oreStacks.isEmpty();
        }
        return false;
    }

    @Override
    public int getFieldCount() {
        return 6;
    }

    @Override
    public void setField(int index, int value) {
        switch (index) {
            case 0: {
                this.temperature = value;
                return;
            }
            case 1: {
                this.oreCount = value;
                return;
            }
            case 2: {
                this.fuelCount = value;
                return;
            }
            case 3: {
                this.meltAmount = value;
                return;
            }
            case 4: {
                this.oreUnits = value;
                return;
            }
            case 5: {
                this.chimney = value;
                return;
            }
        }
        TerraFirmaCraft.getLog().warn("Illegal field id {} in TEBlastFurnace#setField", (Object)index);
    }

    @Override
    public int getField(int index) {
        switch (index) {
            case 0: {
                return (int)this.temperature;
            }
            case 1: {
                return this.oreCount;
            }
            case 2: {
                return this.fuelCount;
            }
            case 3: {
                return this.meltAmount;
            }
            case 4: {
                return this.oreUnits;
            }
            case 5: {
                return this.chimney;
            }
        }
        TerraFirmaCraft.getLog().warn("Illegal field id {} in TEBlastFurnace#getField", (Object)index);
        return 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            TECrucible te;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
                if (this.burnTicksLeft > 0L) {
                    this.burnTicksLeft -= this.airTicks > 0L ? 2L : 1L;
                }
                if (this.burnTicksLeft <= 0L) {
                    if (!this.fuelStacks.isEmpty()) {
                        ItemStack fuelStack = this.fuelStacks.get(0);
                        this.fuelStacks.remove(0);
                        Fuel fuel = FuelManager.getFuel(fuelStack);
                        this.burnTicksLeft = (int)Math.ceil((double)fuel.getAmount() / ConfigTFC.Devices.BLAST_FURNACE.consumption);
                        this.burnTemperature = fuel.getTemperature();
                    } else {
                        this.burnTemperature = 0.0f;
                    }
                    this.markForSync();
                }
                if (this.temperature > 0.0f || this.burnTemperature > 0.0f) {
                    Block blockCrucible;
                    float targetTemperature = this.burnTemperature + (float)this.airTicks;
                    if (this.temperature != targetTemperature) {
                        float delta = (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier;
                        this.temperature = CapabilityItemHeat.adjustTempTowards(this.temperature, targetTemperature, delta * (float)(this.airTicks > 0L ? 2 : 1), delta * (this.airTicks > 0L ? 0.5f : 1.0f));
                    }
                    if ((blockCrucible = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c()) instanceof IHeatConsumerBlock) {
                        ((IHeatConsumerBlock)blockCrucible).acceptHeat(this.field_145850_b, this.field_174879_c.func_177977_b(), this.temperature);
                    }
                    if (!this.field_145850_b.field_72995_K) {
                        this.oreStacks.removeIf(stack -> {
                            IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                            if (cap != null) {
                                float itemTemp = cap.getTemperature();
                                if (this.temperature > itemTemp) {
                                    CapabilityItemHeat.addTemp(cap);
                                }
                                if (cap.isMolten()) {
                                    this.convertToMolten((ItemStack)stack);
                                    ItemStack tuyereStack = this.inventory.getStackInSlot(0);
                                    if (!tuyereStack.func_190926_b()) {
                                        Helpers.damageItem(tuyereStack);
                                    }
                                    return true;
                                }
                            }
                            return false;
                        });
                    }
                    if (this.temperature <= 0.0f && this.burnTemperature <= 0.0f) {
                        this.temperature = 0.0f;
                        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
            this.airTicks = this.airTicks > 0L ? --this.airTicks : 0L;
            this.meltAmount = this.alloy.getAmount();
            if (--this.delayTimer <= 0) {
                int newMaxItems;
                this.delayTimer = 20;
                int oldChimney = this.chimney;
                int oldOre = this.oreCount;
                int oldFuel = this.fuelCount;
                this.chimney = BlockBlastFurnace.getChimneyLevels(this.field_145850_b, this.field_174879_c);
                this.maxFuel = newMaxItems = this.chimney * 4;
                this.maxOre = newMaxItems;
                while (this.maxOre < this.oreStacks.size()) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177978_c().func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177978_c().func_177952_p(), (ItemStack)this.oreStacks.get(0));
                    this.oreStacks.remove(0);
                }
                while (this.maxFuel < this.fuelStacks.size()) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177978_c().func_177958_n(), (double)this.field_174879_c.func_177978_c().func_177956_o(), (double)this.field_174879_c.func_177978_c().func_177952_p(), (ItemStack)this.fuelStacks.get(0));
                    this.fuelStacks.remove(0);
                }
                this.addItemsFromWorld();
                this.updateSlagBlock((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT));
                this.oreCount = this.oreStacks.size();
                this.oreUnits = this.oreStacks.stream().mapToInt(stack -> {
                    IMetalItem metalObject = CapabilityMetalItem.getMetalItem(stack);
                    if (metalObject != null) {
                        return metalObject.getSmeltAmount((ItemStack)stack);
                    }
                    return 1;
                }).sum();
                this.fuelCount = this.fuelStacks.size();
                if (oldChimney != this.chimney || oldOre != this.oreCount || oldFuel != this.fuelCount) {
                    this.markForSync();
                }
            }
            if (this.alloy.removeAlloy(1, true) > 0 && (te = Helpers.getTE((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177977_b(), TECrucible.class)) != null && te.addMetal(this.alloy.getResult(), 1) <= 0) {
                this.alloy.removeAlloy(1, false);
            }
        }
    }

    public void debug() {
        TerraFirmaCraft.getLog().debug("Debugging Blast Furnace:");
        TerraFirmaCraft.getLog().debug("Temp {} | Burn Temp {} | Fuel Ticks {}", (Object)Float.valueOf(this.temperature), (Object)Float.valueOf(this.burnTemperature), (Object)this.burnTicksLeft);
        TerraFirmaCraft.getLog().debug("Burning? {}", (Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)ILightableBlock.LIT));
        int i = 0;
        for (ItemStack item : this.oreStacks) {
            TerraFirmaCraft.getLog().debug("Slot: {} - NBT: {}", (Object)i, (Object)item.serializeNBT().toString());
        }
    }

    public void onAirIntake(int airAmount) {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.func_190926_b() && this.burnTicksLeft > 0L) {
            this.airTicks += (long)airAmount;
            if (this.airTicks > 600L) {
                this.airTicks = 600L;
            }
        }
    }

    private void convertToMolten(ItemStack stack) {
        FluidStack output;
        BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(stack);
        if (recipe != null && (output = recipe.getOutput(stack)) != null) {
            this.alloy.add(output);
        }
    }

    private void addItemsFromWorld() {
        EntityItem fluxEntity = null;
        EntityItem oreEntity = null;
        List items = this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 5, 1)), EntitySelectors.field_94557_a);
        block0: for (EntityItem entityItem : items) {
            ItemStack stack = entityItem.func_92059_d();
            BlastFurnaceRecipe recipe = BlastFurnaceRecipe.get(stack);
            if (recipe != null) {
                oreEntity = entityItem;
                for (EntityItem item : items) {
                    if (!recipe.isValidAdditive(item.func_92059_d())) continue;
                    fluxEntity = item;
                    break;
                }
                if (fluxEntity != null) break;
                oreEntity = null;
            }
            if (!FuelManager.isItemBloomeryFuel(stack)) continue;
            while (this.maxFuel > this.fuelStacks.size()) {
                this.func_70296_d();
                this.fuelStacks.add(stack.func_77979_a(1));
                if (stack.func_190916_E() > 0) continue;
                entityItem.func_70106_y();
                continue block0;
            }
        }
        while (this.maxOre > this.oreStacks.size() && fluxEntity != null && oreEntity != null) {
            this.func_70296_d();
            ItemStack flux = fluxEntity.func_92059_d();
            flux.func_190918_g(1);
            ItemStack ore = oreEntity.func_92059_d();
            this.oreStacks.add(ore.func_77979_a(1));
            if (flux.func_190916_E() <= 0) {
                fluxEntity.func_70106_y();
                fluxEntity = null;
            }
            if (ore.func_190916_E() > 0) continue;
            oreEntity.func_70106_y();
            oreEntity = null;
        }
    }

    private void updateSlagBlock(boolean cooking) {
        int slag = this.fuelStacks.size() + this.oreStacks.size();
        int slagLayers = slag == 1 ? 1 : slag / 2;
        for (int i = 1; i < 6; ++i) {
            if (slagLayers > 0) {
                if (slagLayers >= 4) {
                    slagLayers -= 4;
                    this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(i), BlocksTFC.MOLTEN.func_176223_P().func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(cooking)).func_177226_a((IProperty)BlockMolten.LAYERS, (Comparable)Integer.valueOf(4)));
                    continue;
                }
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(i), BlocksTFC.MOLTEN.func_176223_P().func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(cooking)).func_177226_a((IProperty)BlockMolten.LAYERS, (Comparable)Integer.valueOf(slagLayers)));
                slagLayers = 0;
                continue;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(i)).func_177230_c() != BlocksTFC.MOLTEN) continue;
            this.field_145850_b.func_175698_g(this.field_174879_c.func_177981_b(i));
        }
    }
}

