/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.capability.ISmallVesselHandler;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.inventory.capability.IItemHandlerSidedCallback;
import net.dries007.tfc.objects.inventory.capability.ItemHandlerSidedWrapper;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
public class TECrucible
extends TETickableInventory
implements ITickable,
ITileFields,
IItemHandlerSidedCallback {
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 8;
    public static final int SLOT_OUTPUT = 9;
    public static final int FIELD_TEMPERATURE = 0;
    private final Alloy alloy;
    private final IItemHandler inventoryWrapperExtract;
    private final IItemHandler inventoryWrapperInsert;
    private final HeatRecipe[] cachedRecipes;
    private Metal alloyResult;
    private float temperature;
    private float targetTemperature;
    private int lastFillTimer;

    public TECrucible() {
        super(10);
        this.alloy = new Alloy(ConfigTFC.Devices.CRUCIBLE.tank);
        this.inventoryWrapperExtract = new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, EnumFacing.DOWN);
        this.inventoryWrapperInsert = new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, EnumFacing.UP);
        this.temperature = 0.0f;
        this.lastFillTimer = 0;
        this.cachedRecipes = new HeatRecipe[9];
        Arrays.fill(this.cachedRecipes, null);
    }

    public void acceptHeat(float temperature) {
        if (temperature > this.targetTemperature) {
            this.targetTemperature = temperature;
        }
    }

    public int addMetal(Metal metal, int amount) {
        int overflow = Math.max(0, this.alloy.getAmount() + amount - this.alloy.getMaxAmount());
        this.alloy.add(metal, amount);
        this.temperature = metal.getMeltTemp();
        this.targetTemperature = metal.getMeltTemp();
        this.markForSync();
        return overflow;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack outputStack;
            IItemHeat capOut;
            this.temperature = CapabilityItemHeat.adjustTempTowards(this.temperature, this.targetTemperature, (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier);
            if (this.targetTemperature > 0.0f) {
                this.targetTemperature -= (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier;
            }
            boolean canFill = this.lastFillTimer <= 0;
            for (int i = 0; i <= 8; ++i) {
                ItemStack inputStack = this.inventory.getStackInSlot(i);
                IItemHeat cap = (IItemHeat)inputStack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                if (cap != null) {
                    if (cap.getTemperature() < this.temperature) {
                        CapabilityItemHeat.addTemp(cap);
                    }
                    if (this.cachedRecipes[i] != null && this.cachedRecipes[i].isValidTemperature(cap.getTemperature())) {
                        this.alloy.add(inputStack, this.cachedRecipes[i]);
                        ItemStack outputStack2 = this.cachedRecipes[i].getOutputStack(inputStack);
                        CapabilityFood.applyTrait(outputStack2, FoodTrait.BURNT_TO_A_CRISP);
                        this.inventory.setStackInSlot(i, outputStack2);
                        inputStack = this.inventory.getStackInSlot(i);
                        cap = (IItemHeat)inputStack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                        this.markForSync();
                    }
                }
                if (!(cap instanceof IMoldHandler)) continue;
                IMoldHandler mold = (IMoldHandler)cap;
                if (!canFill || !mold.isMolten()) continue;
                Metal metal = mold.getMetal();
                FluidStack fluidStack = mold.drain(ConfigTFC.Devices.CRUCIBLE.pouringSpeed, true);
                if (fluidStack == null || fluidStack.amount <= 0) continue;
                this.lastFillTimer = 5;
                if (!ConfigTFC.Devices.CRUCIBLE.enableAllSlots) {
                    canFill = false;
                }
                this.alloy.add(metal, fluidStack.amount);
                this.markForSync();
            }
            if (this.lastFillTimer > 0) {
                --this.lastFillTimer;
            }
            if ((capOut = (IItemHeat)(outputStack = this.inventory.getStackInSlot(9)).getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) instanceof IMoldHandler) {
                Fluid metalFluid;
                FluidStack fluidStack;
                int amountFilled;
                int amountToFill;
                IMoldHandler mold = (IMoldHandler)capOut;
                Metal alloyMetal = this.alloy.getResult();
                if (this.temperature > alloyMetal.getMeltTemp() && (amountToFill = this.alloy.removeAlloy(1, true)) > 0 && (amountFilled = mold.fill(fluidStack = new FluidStack(metalFluid = FluidsTFC.getFluidFromMetal(alloyMetal), amountToFill), true)) > 0) {
                    this.alloy.removeAlloy(amountFilled, false);
                    capOut.setTemperature(this.temperature);
                    this.markForSync();
                }
            }
            if (this.needsClientUpdate) {
                this.alloyResult = this.alloy.getResult();
            }
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        IFluidHandler cap;
        if (!stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) {
            return false;
        }
        if (slot != 9 && (cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) instanceof IMoldHandler) {
            if (cap instanceof ISmallVesselHandler) {
                if (((ISmallVesselHandler)cap).getMetal() != null) {
                    return true;
                }
                for (int i = 0; i < ((ISmallVesselHandler)cap).getSlots(); ++i) {
                    if (((ISmallVesselHandler)cap).getStackInSlot(i).func_190926_b()) continue;
                    return true;
                }
                return false;
            }
            return ((IMoldHandler)cap).getAmount() > 0;
        }
        return slot != 9 || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (slot != 9) {
            this.cachedRecipes[slot] = HeatRecipe.get(this.inventory.getStackInSlot(slot));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.alloy.deserializeNBT(nbt.func_74775_l("alloy"));
        this.temperature = nbt.func_74760_g("temp");
        this.alloy.setMaxAmount(ConfigTFC.Devices.CRUCIBLE.tank);
        this.alloyResult = this.alloy.getResult();
        super.func_145839_a(nbt);
        for (int i = 0; i <= 8; ++i) {
            this.cachedRecipes[i] = HeatRecipe.get(this.inventory.getStackInSlot(i));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("alloy", (NBTBase)this.alloy.serializeNBT());
        nbt.func_74776_a("temp", this.temperature);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.inventoryWrapperExtract;
            }
            return (T)this.inventoryWrapperInsert;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        super.onBreakBlock(world, pos, state);
        ItemStack stack = new ItemStack((Block)BlocksTFC.CRUCIBLE);
        if (this.alloy.getAmount() > 0) {
            stack.func_77982_d(this.writeToItemTag());
        }
        Helpers.spawnItemStack(world, pos, stack);
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    public void setField(int index, int value) {
        if (index == 0) {
            this.temperature = value;
            return;
        }
        TerraFirmaCraft.getLog().warn("Illegal field id {} in TECrucible#setField", (Object)index);
    }

    @Override
    public int getField(int index) {
        if (index == 0) {
            return (int)this.temperature;
        }
        TerraFirmaCraft.getLog().warn("Illegal field id {} in TECrucible#getField", (Object)index);
        return 0;
    }

    public NBTTagCompound writeToItemTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("alloy", (NBTBase)this.alloy.serializeNBT());
        return nbt;
    }

    public void readFromItemTag(NBTTagCompound nbt) {
        this.alloy.deserializeNBT(nbt.func_74775_l("alloy"));
        this.alloy.setMaxAmount(ConfigTFC.Devices.CRUCIBLE.tank);
        this.alloyResult = this.alloy.getResult();
    }

    @Nonnull
    public Alloy getAlloy() {
        return this.alloy;
    }

    @Nonnull
    public Metal getAlloyResult() {
        return this.alloyResult;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack, EnumFacing side) {
        IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (cap instanceof IMoldHandler) {
            return side != EnumFacing.DOWN && slot == 9;
        }
        return side != EnumFacing.DOWN && slot != 9;
    }

    @Override
    public boolean canExtract(int slot, EnumFacing side) {
        if (side == EnumFacing.DOWN && slot == 9) {
            ItemStack stack = this.inventory.getStackInSlot(9);
            IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (cap != null) {
                return cap.drain(1, false) != null && cap.fill(cap.drain(1, false), false) <= 0;
            }
            return true;
        }
        return false;
    }
}

