/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.objects.fluids.capability.FluidHandlerSided;
import net.dries007.tfc.objects.fluids.capability.FluidTankCallback;
import net.dries007.tfc.objects.fluids.capability.FluidWhitelistHandlerComplex;
import net.dries007.tfc.objects.fluids.capability.IFluidHandlerSidedCallback;
import net.dries007.tfc.objects.fluids.capability.IFluidTankCallback;
import net.dries007.tfc.objects.items.itemblock.ItemBlockMetalLamp;
import net.dries007.tfc.objects.te.TETickCounter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
public class TELamp
extends TETickCounter
implements IFluidTankCallback,
IFluidHandlerSidedCallback {
    public static int CAPACITY;
    private final FluidTank tank = new FluidTankCallback(this, 0, CAPACITY);
    private boolean powered = false;

    public TELamp() {
        CAPACITY = ConfigTFC.Devices.LAMP.tank;
        this.tank.setCapacity(CAPACITY);
        this.tank.setTileEntity((TileEntity)this);
    }

    public int getFuel() {
        return this.tank.getFluidAmount();
    }

    @Override
    public void setAndUpdateFluidTank(int fluidTankID) {
        this.markForBlockUpdate();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerSided(this, (IFluidHandler)this.tank, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean canFill(FluidStack resource, EnumFacing side) {
        if (resource == null) {
            return false;
        }
        return ItemBlockMetalLamp.getValidFluids().contains(resource.getFluid());
    }

    @Override
    public boolean canDrain(EnumFacing side) {
        return true;
    }

    public ItemStack getItemStack(TELamp tel, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c());
        IFluidHandlerItem itemCap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        IFluidHandler teCap = (IFluidHandler)tel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (itemCap != null && teCap != null) {
            itemCap.fill(teCap.drain(CAPACITY, false), true);
        }
        return stack;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
            FluidStack fluidStack = this.tank.getFluid();
            if (fluidStack != null) {
                fluidStack.amount = this.tank.getCapacity();
            }
            this.tank.setFluid(fluidStack);
        }
        this.markForSync();
        this.powered = nbt.func_74767_n("powered");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("powered", this.powered);
        return super.func_189515_b(nbt);
    }

    public void loadFromItemStack(ItemStack stack) {
        NBTTagCompound contents;
        IFluidHandler lampCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (lampCap instanceof FluidWhitelistHandlerComplex && (contents = stack.func_77978_p()) != null) {
            this.tank.fill(((FluidWhitelistHandlerComplex)lampCap).getFluid(), true);
            this.markForSync();
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean pow) {
        this.powered = pow;
    }
}

