/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.recipes.LoomRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.wood.BlockLoom;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.te.TEInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class TELoom
extends TEInventory
implements ITickable {
    private Tree cachedWood;
    private int progress = 0;
    private LoomRecipe recipe = null;
    private long lastPushed = 0L;
    private boolean needsUpdate = false;

    public TELoom() {
        super(2);
    }

    @Nullable
    public Tree getWood() {
        if (this.cachedWood == null && this.field_145850_b != null) {
            this.cachedWood = ((BlockLoom)this.field_145850_b.func_180495_p((BlockPos)this.field_174879_c).func_177230_c()).wood;
        }
        return this.cachedWood;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.lastPushed = nbt.func_74763_f("lastPushed");
        this.recipe = nbt.func_74764_b("recipe") ? (LoomRecipe)TFCRegistries.LOOM.getValue(new ResourceLocation(nbt.func_74779_i("recipe"))) : null;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74772_a("lastPushed", this.lastPushed);
        if (this.recipe != null) {
            nbt.func_74778_a("recipe", this.recipe.getRegistryName().toString());
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public double getAnimPos() {
        int time = (int)(this.field_145850_b.func_82737_E() - this.lastPushed);
        if (time < 10) {
            return Math.sin(0.15707963267948966 * (double)time) * 0.23125;
        }
        if (time < 20) {
            return Math.sin(0.15707963267948966 * (double)(20 - time)) * 0.23125;
        }
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public String getAnimElement() {
        return this.progress % 2 == 0 ? "u" : "l";
    }

    public boolean onRightClick(EntityPlayer player) {
        if (player.func_70093_af()) {
            ItemStack heldItem;
            if (!this.inventory.getStackInSlot(0).func_190926_b() && this.progress == 0 && (heldItem = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b()) {
                ItemStack temp = this.inventory.getStackInSlot(0).func_77946_l();
                temp.func_190920_e(1);
                player.func_191521_c(temp);
                this.inventory.getStackInSlot(0).func_190918_g(1);
                if (this.inventory.getStackInSlot(0).func_190926_b()) {
                    this.recipe = null;
                }
                this.markForBlockUpdate();
                return true;
            }
        } else {
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(1).func_190926_b() && LoomRecipe.get(heldItem) != null) {
                this.inventory.setStackInSlot(0, heldItem.func_77946_l());
                this.inventory.getStackInSlot(0).func_190920_e(1);
                heldItem.func_190918_g(1);
                this.recipe = LoomRecipe.get(this.inventory.getStackInSlot(0));
                this.markForBlockUpdate();
                return true;
            }
            if (!this.inventory.getStackInSlot(0).func_190926_b() && IIngredient.of(this.inventory.getStackInSlot(0)).testIgnoreCount(heldItem) && this.recipe.getInputCount() > this.inventory.getStackInSlot(0).func_190916_E()) {
                heldItem.func_190918_g(1);
                this.inventory.getStackInSlot(0).func_190917_f(1);
                this.markForBlockUpdate();
                return true;
            }
            if (this.recipe != null && heldItem.func_190926_b() && this.recipe.getInputCount() == this.inventory.getStackInSlot(0).func_190916_E() && this.progress < this.recipe.getStepCount() && !this.needsUpdate) {
                if (!this.field_145850_b.field_72995_K) {
                    long time = this.field_145850_b.func_82737_E() - this.lastPushed;
                    if (time < 20L) {
                        return true;
                    }
                    this.lastPushed = this.field_145850_b.func_82737_E();
                    this.needsUpdate = true;
                    this.markForSync();
                }
                return true;
            }
            if (!this.inventory.getStackInSlot(1).func_190926_b() && heldItem.func_190926_b()) {
                player.func_191521_c(this.inventory.getStackInSlot(1).func_77946_l());
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                this.progress = 0;
                this.recipe = null;
                this.markForBlockUpdate();
                return true;
            }
        }
        return false;
    }

    public void func_73660_a() {
        if (this.recipe != null) {
            LoomRecipe recipe = this.recipe;
            if (this.needsUpdate && this.field_145850_b.func_82737_E() - this.lastPushed >= 20L) {
                this.needsUpdate = false;
                ++this.progress;
                if (this.progress == recipe.getStepCount()) {
                    this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    this.inventory.setStackInSlot(1, recipe.getOutputItem());
                }
                this.markForBlockUpdate();
            }
        }
    }

    public int getMaxInputCount() {
        return this.recipe == null ? 1 : this.recipe.getInputCount();
    }

    public int getCount() {
        return this.inventory.getStackInSlot(0).func_190916_E();
    }

    public int getMaxProgress() {
        return this.recipe == null ? 1 : this.recipe.getStepCount();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public ResourceLocation getInProgressTexture() {
        return this.recipe.getInProgressTexture();
    }
}

