/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.devices.BlockPitKiln;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.te.TEPlacedItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class TEPitKiln
extends TEPlacedItem
implements ITickable {
    public static final int STRAW_NEEDED = 8;
    public static final int WOOD_NEEDED = 8;
    public static final Vec3i[] DIAGONALS = new Vec3i[]{new Vec3i(1, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, -1)};
    private final NonNullList<ItemStack> logItems = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> strawItems = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private long litTick;
    private boolean isLit;

    public static void convertPlacedItemToPitKiln(World world, BlockPos pos, ItemStack strawStack) {
        TEPlacedItem teOld = Helpers.getTE((IBlockAccess)world, pos, TEPlacedItem.class);
        if (teOld != null) {
            IItemHandler capOld = (IItemHandler)teOld.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack[] inventory = new ItemStack[4];
            if (capOld != null) {
                for (int i = 0; i < 4; ++i) {
                    inventory[i] = capOld.extractItem(i, 64, false);
                }
            }
            world.func_175656_a(pos, BlocksTFC.PIT_KILN.func_176223_P());
            world.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.5f, 1.0f);
            TEPitKiln teNew = Helpers.getTE((IBlockAccess)world, pos, TEPitKiln.class);
            if (teNew != null) {
                IItemHandler capNew = (IItemHandler)teNew.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (capNew != null) {
                    for (int i = 0; i < 4; ++i) {
                        if (inventory[i] == null || inventory[i].func_190926_b()) continue;
                        capNew.insertItem(i, inventory[i], false);
                    }
                }
                teNew.isHoldingLargeItem = teOld.isHoldingLargeItem;
                if (OreDictionaryHelper.doesStackMatchOre(strawStack, "blockStraw")) {
                    teNew.addStrawBlock();
                } else {
                    teNew.addStraw(strawStack.func_77979_a(1));
                }
            }
        }
    }

    public void func_73660_a() {
        if (this.isLit) {
            long remainingTicks;
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                BlockPos above = this.field_174879_c.func_177984_a();
                if (this.field_145850_b.func_175623_d(above)) {
                    this.field_145850_b.func_175656_a(above, Blocks.field_150480_ab.func_176223_P());
                } else {
                    IBlockState stateAbove = this.field_145850_b.func_180495_p(above);
                    if (stateAbove.func_185904_a() != Material.field_151581_o) {
                        this.emptyFuelContents();
                        TEPitKiln.convertPitKilnToPlacedItem(this.field_145850_b, this.field_174879_c);
                        return;
                    }
                }
                if (!this.isValid()) {
                    this.emptyFuelContents();
                    TEPitKiln.convertPitKilnToPlacedItem(this.field_145850_b, this.field_174879_c);
                    return;
                }
            }
            if ((remainingTicks = (long)ConfigTFC.Devices.PIT_KILN.ticks - (CalendarTFC.PLAYER_TIME.getTicks() - this.litTick)) <= 0L) {
                this.emptyFuelContents();
                if (remainingTicks < 0L) {
                    CalendarTFC.runTransaction(remainingTicks, 0L, this::cookContents);
                } else {
                    this.cookContents();
                }
                this.field_145850_b.func_175698_g(this.field_174879_c.func_177984_a());
                this.updateBlock();
                TEPlacedItem.convertPitKilnToPlacedItem(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    @Override
    public void onBreakBlock(World worldIn, BlockPos pos, IBlockState state) {
        this.strawItems.forEach(i -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)i));
        this.logItems.forEach(i -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)i));
        super.onBreakBlock(worldIn, pos, state);
    }

    public boolean isLit() {
        return this.isLit;
    }

    public long getLitTick() {
        return this.litTick;
    }

    public boolean hasFuel() {
        return !this.logItems.stream().anyMatch(ItemStack::func_190926_b) && !this.strawItems.stream().anyMatch(ItemStack::func_190926_b);
    }

    @Override
    public boolean onRightClick(EntityPlayer player, ItemStack stack, boolean x, boolean z) {
        if (this.isLit()) {
            return false;
        }
        if (player.func_70093_af()) {
            ItemStack dropStack = this.logItems.stream().filter(i -> !i.func_190926_b()).findFirst().orElseGet(() -> this.strawItems.stream().filter(i -> !i.func_190926_b()).findFirst().orElse(ItemStack.field_190927_a));
            if (!dropStack.func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)dropStack.func_77979_a(1));
                this.updateBlock();
                if (this.getStrawCount() == 0) {
                    TEPlacedItem.convertPitKilnToPlacedItem(this.field_145850_b, this.field_174879_c);
                }
                return true;
            }
        } else if (!stack.func_190926_b()) {
            int strawCount = this.getStrawCount();
            int logCount = this.getLogCount();
            if (OreDictionaryHelper.doesStackMatchOre(stack, "straw") && strawCount < 8) {
                this.addStraw(stack.func_77979_a(1));
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.5f, 1.0f);
                this.updateBlock();
                return true;
            }
            if (stack.func_77973_b() == Item.func_150898_a((Block)BlocksTFC.THATCH) && strawCount <= 4) {
                stack.func_190918_g(1);
                this.addStrawBlock();
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.5f, 1.0f);
                this.updateBlock();
                return true;
            }
            if (strawCount == 8) {
                if (OreDictionaryHelper.doesStackMatchOre(stack, "logWood") && logCount < 8) {
                    this.addLog(stack.func_77979_a(1));
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    this.updateBlock();
                    return true;
                }
                if (logCount == 8 && stack.func_77973_b() instanceof ItemFlintAndSteel) {
                    return this.tryLight();
                }
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.isLit = nbt.func_74767_n("isLit");
        this.litTick = nbt.func_74763_f("litTick");
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("strawItems"), this.strawItems);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("logItems"), this.logItems);
        super.func_145839_a(nbt);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("isLit", this.isLit);
        nbt.func_74772_a("litTick", this.litTick);
        nbt.func_74782_a("strawItems", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.strawItems));
        nbt.func_74782_a("logItems", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.logItems));
        return super.func_189515_b(nbt);
    }

    @Override
    protected void updateBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPitKiln.FULL, (Comparable)Boolean.valueOf(this.getStrawCount() == 8 && this.getLogCount() == 8)));
        this.markForBlockUpdate();
    }

    public int getLogCount() {
        return (int)this.logItems.stream().filter(i -> !i.func_190926_b()).count();
    }

    public int getStrawCount() {
        return (int)this.strawItems.stream().filter(i -> !i.func_190926_b()).count();
    }

    public boolean tryLight() {
        BlockPos above;
        if (this.hasFuel() && this.isValid() && !this.isLit() && Blocks.field_150480_ab.func_176196_c(this.field_145850_b, above = this.field_174879_c.func_177984_a())) {
            for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                if (this.field_145850_b.isSideSolid(this.field_174879_c.func_177972_a(enumFacing), enumFacing.func_176734_d())) continue;
                return false;
            }
            this.isLit = true;
            this.litTick = CalendarTFC.PLAYER_TIME.getTicks();
            this.updateBlock();
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockPitKiln.LIT, (Comparable)Boolean.valueOf(true)));
            this.field_145850_b.func_175656_a(above, Blocks.field_150480_ab.func_176223_P());
            for (EnumFacing enumFacing : DIAGONALS) {
                BlockPos pitPos = this.field_174879_c.func_177971_a((Vec3i)enumFacing);
                TEPitKiln pitKiln = Helpers.getTE((IBlockAccess)this.field_145850_b, pitPos, TEPitKiln.class);
                if (pitKiln == null) continue;
                pitKiln.tryLight();
            }
            return true;
        }
        return false;
    }

    public void emptyFuelContents() {
        this.strawItems.clear();
        this.logItems.clear();
    }

    private void cookContents() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            ItemStack outputStack = ItemStack.field_190927_a;
            IItemHeat heat = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            if (heat != null) {
                IItemHeat outputHeat;
                heat.setTemperature(Heat.maxVisibleTemperature());
                HeatRecipe recipe = HeatRecipe.get(stack, Metal.Tier.TIER_I);
                if (recipe != null) {
                    outputStack = recipe.getOutputStack(stack);
                }
                if ((outputHeat = (IItemHeat)outputStack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) != null) {
                    outputHeat.setTemperature(Heat.maxVisibleTemperature());
                }
            }
            this.inventory.setStackInSlot(i, outputStack);
        }
    }

    private void addStrawBlock() {
        for (int i = 0; i < 4; ++i) {
            this.addStraw(new ItemStack((Item)ItemsTFC.STRAW));
        }
    }

    private void addStraw(ItemStack stack) {
        for (int i = 0; i < this.strawItems.size(); ++i) {
            if (!((ItemStack)this.strawItems.get(i)).func_190926_b()) continue;
            this.strawItems.set(i, (Object)stack);
            return;
        }
    }

    private void addLog(ItemStack stack) {
        for (int i = 0; i < this.logItems.size(); ++i) {
            if (!((ItemStack)this.logItems.get(i)).func_190926_b()) continue;
            this.logItems.set(i, (Object)stack);
            return;
        }
    }

    private boolean isValid() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(face)).func_185915_l()) continue;
            return false;
        }
        return this.field_145850_b.isSideSolid(this.field_174879_c.func_177977_b(), EnumFacing.UP);
    }
}

