/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.items.metal.ItemMetalTool;
import net.dries007.tfc.objects.te.TEBase;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class TEToolRack
extends TEBase {
    private final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);

    public static boolean isItemEligible(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemMetalTool || item instanceof ItemTool || item instanceof ItemBow || item instanceof ItemHoe || item instanceof ItemSword || item instanceof ItemFireStarter || item instanceof ItemFlintAndSteel || OreDictionaryHelper.doesStackMatchOre(stack, "tool");
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void onBreakBlock() {
        this.items.forEach(i -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)i));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.items.clear();
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("items"), this.items);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("items", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.items));
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.markForBlockUpdate();
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, int slot) {
        ItemStack slotItem = (ItemStack)this.items.get(slot);
        ItemStack heldItem = player.func_184586_b(hand);
        if (!slotItem.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)slotItem.func_77979_a(1));
            this.items.set(slot, (Object)ItemStack.field_190927_a);
        } else if (TEToolRack.isItemEligible(heldItem)) {
            this.items.set(slot, (Object)(player.func_184812_l_() ? heldItem.func_77946_l() : heldItem.func_77979_a(1)));
        } else {
            return false;
        }
        this.markForBlockUpdate();
        return true;
    }
}

