/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.proxy;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.proxy.IProxy;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class ServerProxy
implements IProxy {
    @Override
    @Nonnull
    public IThreadListener getThreadListener(MessageContext context) {
        if (context.side.isServer()) {
            return context.getServerHandler().field_147369_b.field_71133_b;
        }
        throw new IProxy.WrongSideException("Tried to get the IThreadListener from a client-side MessageContext on the dedicated server");
    }

    @Override
    @Nullable
    public EntityPlayer getPlayer(MessageContext context) {
        if (context.side.isServer()) {
            return context.getServerHandler().field_147369_b;
        }
        throw new IProxy.WrongSideException("Tried to get the player from a client-side MessageContext on the dedicated server");
    }

    @Override
    @Nullable
    public World getWorld(MessageContext context) {
        if (context.side.isServer()) {
            return context.getServerHandler().field_147369_b.func_71121_q();
        }
        throw new IProxy.WrongSideException("Tried to get the player from a client-side MessageContext on the dedicated server");
    }

    @Override
    @Nonnull
    public String getMonthName(Month month, boolean useSeasons) {
        return month.name().toLowerCase();
    }

    @Override
    @Nonnull
    public String getDayName(int dayOfMonth, long totalDays) {
        return CalendarTFC.DAY_NAMES[(int)(totalDays % 7L)];
    }

    @Override
    @Nonnull
    public String getDate(int hour, int minute, String monthName, int day, long years) {
        return String.format("%02d:%02d %s %02d, %04d", hour, minute, monthName, day, years);
    }
}

