/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.recipes.AlloyRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.fluids.properties.MetalProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;

public class Alloy
implements INBTSerializable<NBTTagCompound> {
    public static final int SAFE_MAX_ALLOY = 100000;
    public static final double EPSILON = 1.0E-5;
    private final Object2DoubleMap<Metal> metalMap = new Object2DoubleOpenHashMap();
    private final Object2DoubleMap<Metal> sanitizedMetalMap = new Object2DoubleOpenHashMap();
    private int totalUnits = 0;
    private int maxUnits;

    public Alloy() {
        this(100000);
    }

    public Alloy(int maxAmount) {
        this.maxUnits = maxAmount;
    }

    public Alloy add(@Nonnull FluidStack stack) {
        MetalProperty metalProperty = FluidsTFC.getWrapper(stack.getFluid()).get(MetalProperty.METAL);
        if (metalProperty != null) {
            Metal metal = metalProperty.getMetal();
            this.add(metal, stack.amount);
        }
        return this;
    }

    public Alloy add(@Nonnull ItemStack stack) {
        return this.add(stack, Metal.Tier.TIER_VI, Float.MAX_VALUE);
    }

    public Alloy add(@Nonnull ItemStack stack, @Nonnull Metal.Tier deviceTier, float temperature) {
        if (!stack.func_190926_b()) {
            HeatRecipe recipe = HeatRecipe.get(stack, deviceTier);
            if (recipe != null && recipe.isValidTemperature(temperature)) {
                return this.add(stack, recipe);
            }
            IMetalItem metalObject = CapabilityMetalItem.getMetalItem(stack);
            if (metalObject != null) {
                this.add(new FluidStack(FluidsTFC.getFluidFromMetal(Metal.UNKNOWN), metalObject.getSmeltAmount(stack) * stack.func_190916_E()));
            }
        }
        return this;
    }

    public Alloy add(@Nonnull ItemStack stack, @Nonnull HeatRecipe recipe) {
        FluidStack fluidStack;
        if (!stack.func_190926_b() && (fluidStack = recipe.getOutputFluid(stack)) != null) {
            fluidStack.amount *= stack.func_190916_E();
            this.add(fluidStack);
        }
        return this;
    }

    public Alloy add(@Nonnull Alloy other) {
        int newTotalAmount = this.totalUnits + other.totalUnits;
        double keepRatio = 1.0;
        if (newTotalAmount > this.maxUnits) {
            keepRatio = (double)(this.maxUnits - this.totalUnits) / (double)other.totalUnits;
        }
        this.totalUnits += other.totalUnits;
        for (Map.Entry entry : other.metalMap.entrySet()) {
            this.metalMap.merge(entry.getKey(), (Object)(keepRatio * (Double)entry.getValue()), Double::sum);
        }
        this.updateSanitizedMap();
        return this;
    }

    public Alloy add(@Nullable Metal metal, int amount) {
        if (metal != null) {
            if (this.totalUnits + amount >= this.maxUnits && (amount = this.maxUnits - this.totalUnits) <= 0) {
                return this;
            }
            this.metalMap.merge((Object)metal, (Object)amount, Double::sum);
            this.totalUnits += amount;
            this.updateSanitizedMap();
        }
        return this;
    }

    @Nonnull
    public Metal getResult() {
        if (this.metalMap.size() == 1) {
            return (Metal)((Object)this.metalMap.keySet().iterator().next());
        }
        for (AlloyRecipe r : TFCRegistries.ALLOYS.getValuesCollection()) {
            if (!this.matchesRecipe(r)) continue;
            return r.getResult();
        }
        return Metal.UNKNOWN;
    }

    public int removeAlloy(int removeAmount, boolean simulate) {
        if (simulate) {
            return Math.min(this.totalUnits, removeAmount);
        }
        if (removeAmount >= this.totalUnits) {
            this.clear();
            return this.totalUnits;
        }
        Object2DoubleOpenHashMap resultMap = new Object2DoubleOpenHashMap(this.metalMap.size());
        for (Map.Entry entry : this.metalMap.entrySet()) {
            double remove = (double)removeAmount * (Double)entry.getValue() / (double)this.totalUnits;
            if (!((Double)entry.getValue() > remove)) continue;
            resultMap.put(entry.getKey(), (Double)entry.getValue() - remove);
        }
        this.totalUnits -= removeAmount;
        this.metalMap.clear();
        this.metalMap.putAll((Map)resultMap);
        this.updateSanitizedMap();
        return removeAmount;
    }

    public int getAmount() {
        return this.totalUnits;
    }

    public int getMaxAmount() {
        return this.maxUnits;
    }

    public void setMaxAmount(int value) {
        int surplus = this.getAmount() - value;
        if (surplus > 0) {
            this.removeAlloy(surplus, false);
        }
        this.maxUnits = value;
    }

    public Map<Metal, Double> getMetals() {
        return this.sanitizedMetalMap;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("maxAmount", this.maxUnits);
        nbt.func_74768_a("totalAmount", this.totalUnits);
        NBTTagCompound alloys = new NBTTagCompound();
        for (Map.Entry entry : this.metalMap.entrySet()) {
            alloys.func_74780_a(((Metal)((Object)entry.getKey())).getRegistryName().toString(), ((Double)entry.getValue()).doubleValue());
        }
        nbt.func_74782_a("contents", (NBTBase)alloys);
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.clear();
            this.maxUnits = nbt.func_74762_e("maxAmount");
            this.totalUnits = nbt.func_74762_e("totalAmount");
            NBTTagCompound alloys = nbt.func_74775_l("contents");
            for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
                String key = metal.getRegistryName().toString();
                if (!alloys.func_74764_b(key)) continue;
                double amount = alloys.func_74769_h(key);
                this.metalMap.put((Object)metal, amount);
            }
            this.updateSanitizedMap();
        }
    }

    private void clear() {
        this.metalMap.clear();
        this.totalUnits = 0;
    }

    private void updateSanitizedMap() {
        this.sanitizedMetalMap.clear();
        double actualTotalAmount = this.getAmountAccurately();
        this.metalMap.forEach((metal, value) -> {
            if (value > actualTotalAmount * 1.0E-5) {
                this.sanitizedMetalMap.put((Object)metal, value);
            }
        });
    }

    private double getAmountAccurately() {
        return this.metalMap.values().stream().mapToDouble(x -> x).sum();
    }

    private boolean matchesRecipe(AlloyRecipe recipe) {
        if (this.metalMap.containsKey((Object)recipe.getResult())) {
            Alloy other = new Alloy().add(this);
            other.metalMap.remove((Object)recipe.getResult());
            other.updateSanitizedMap();
            return other.matchesRecipeExact(recipe);
        }
        return this.matchesRecipeExact(recipe);
    }

    private boolean matchesRecipeExact(AlloyRecipe recipe) {
        Map<Metal, Double> metals = this.getMetals();
        double actualTotalAmount = this.getAmountAccurately();
        for (Metal metal : Sets.union((Set)recipe.getMetals().keySet(), metals.keySet())) {
            if (metals.containsKey((Object)metal) && recipe.getMetals().containsKey((Object)metal) && ((AlloyRecipe.DoubleRange)recipe.getMetals().get((Object)metal)).test(metals.get((Object)metal) / actualTotalAmount)) continue;
            return false;
        }
        return true;
    }
}

