/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.ArrayList;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.worldtracker.CapabilityWorldTracker;
import net.dries007.tfc.api.capability.worldtracker.CollapseData;
import net.dries007.tfc.api.capability.worldtracker.WorldTracker;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariantFallable;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.util.IFallingBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public interface ICollapsableBlock {
    public BlockRockVariantFallable getFallingVariant();

    default public boolean canCollapse(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j();
    }

    default public boolean checkCollapsingArea(World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K || !worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
            return false;
        }
        if (Constants.RNG.nextDouble() < ConfigTFC.General.FALLABLE.collapseChance) {
            int radX = (Constants.RNG.nextInt(5) + 4) / 2;
            int radY = (Constants.RNG.nextInt(3) + 2) / 2;
            int radZ = (Constants.RNG.nextInt(5) + 4) / 2;
            for (BlockPos checking : BlockSupport.getAllUnsupportedBlocksIn(worldIn, pos.func_177982_a(-radX, -radY, -radZ), pos.func_177982_a(radX, radY, radZ))) {
                ICollapsableBlock block;
                if (!(worldIn.func_180495_p(checking).func_177230_c() instanceof ICollapsableBlock) || !(block = (ICollapsableBlock)worldIn.func_180495_p(checking).func_177230_c()).canCollapse(worldIn, checking)) continue;
                block.collapseArea(worldIn, checking);
                worldIn.func_184133_a(null, pos, TFCSounds.ROCK_SLIDE_LONG, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    default public void collapseArea(World world, BlockPos centerPoint) {
        WorldTracker tracker;
        int radius = (world.field_73012_v.nextInt(31) + 5) / 2;
        int radiusSquared = radius * radius;
        ArrayList<BlockPos> secondaryPositions = new ArrayList<BlockPos>();
        block0: for (BlockPos pos : BlockPos.func_177975_b((BlockPos)centerPoint.func_177982_a(-radius, -4, -radius), (BlockPos)centerPoint.func_177982_a(radius, -4, radius))) {
            boolean foundEmpty = false;
            for (int y = 0; y <= 8; ++y) {
                BlockPos posAt = pos.func_177981_b(y);
                IBlockState stateAt = world.func_180495_p(posAt);
                if (foundEmpty && stateAt.func_177230_c() instanceof ICollapsableBlock && ((ICollapsableBlock)stateAt.func_177230_c()).canCollapse(world, posAt) && !BlockSupport.isBeingSupported(world, posAt) && posAt.func_177951_i((Vec3i)centerPoint) < (double)radiusSquared && (double)world.field_73012_v.nextFloat() < ConfigTFC.General.FALLABLE.propagateCollapseChance) {
                    BlockRockVariantFallable fallingBlock = ((ICollapsableBlock)stateAt.func_177230_c()).getFallingVariant();
                    world.func_175656_a(posAt, fallingBlock.func_176223_P());
                    fallingBlock.checkFalling(world, posAt, world.func_180495_p(posAt), true);
                    secondaryPositions.add(posAt.func_177984_a());
                    continue block0;
                }
                if (!IFallingBlock.canFallThrough(world, posAt, stateAt.func_185904_a())) continue;
                foundEmpty = true;
            }
        }
        if (!secondaryPositions.isEmpty() && (tracker = (WorldTracker)world.getCapability(CapabilityWorldTracker.CAPABILITY, null)) != null) {
            tracker.addCollapseData(new CollapseData(centerPoint, secondaryPositions, radiusSquared));
        }
    }
}

