/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.agriculture;

import java.util.List;
import javax.annotation.Nullable;
import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.util.agriculture.Food;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.world.classic.worldgen.WorldGenFruitTrees;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum FruitTree implements IFruitTree
{
    BANANA(Food.BANANA, Month.APRIL, 2, Month.SEPTEMBER, 1, 23.0f, 35.0f, 280.0f, 400.0f, 0.33f),
    CHERRY(Food.CHERRY, Month.APRIL, 1, Month.JUNE, 1, 5.0f, 21.0f, 100.0f, 350.0f, 0.33f),
    GREEN_APPLE(Food.GREEN_APPLE, Month.MAY, 2, Month.OCTOBER, 2, 8.0f, 25.0f, 110.0f, 280.0f, 0.33f),
    LEMON(Food.LEMON, Month.MAY, 2, Month.AUGUST, 1, 10.0f, 30.0f, 180.0f, 400.0f, 0.33f),
    OLIVE(Food.OLIVE, Month.JUNE, 1, Month.OCTOBER, 2, 13.0f, 30.0f, 150.0f, 380.0f, 0.33f),
    ORANGE(Food.ORANGE, Month.FEBRUARY, 3, Month.NOVEMBER, 1, 23.0f, 36.0f, 250.0f, 400.0f, 0.33f),
    PEACH(Food.PEACH, Month.APRIL, 2, Month.SEPTEMBER, 1, 9.0f, 27.0f, 60.0f, 230.0f, 0.33f),
    PLUM(Food.PLUM, Month.MAY, 2, Month.JULY, 2, 18.0f, 31.0f, 250.0f, 400.0f, 0.33f),
    RED_APPLE(Food.RED_APPLE, Month.MAY, 2, Month.OCTOBER, 2, 9.0f, 25.0f, 100.0f, 280.0f, 0.33f);

    private final Food fruit;
    private final Month flowerMonthStart;
    private final int floweringMonths;
    private final Month harvestMonthStart;
    private final int harvestingMonths;
    private final float growthTime;
    private final float minTemp;
    private final float maxTemp;
    private final float minRain;
    private final float maxRain;

    private FruitTree(Food fruit, Month flowerMonthStart, int floweringMonths, Month harvestMonthStart, int harvestingMonths, float minTemp, float maxTemp, float minRain, float maxRain, float growthTime) {
        this.fruit = fruit;
        this.flowerMonthStart = flowerMonthStart;
        this.floweringMonths = floweringMonths;
        this.harvestMonthStart = harvestMonthStart;
        this.harvestingMonths = harvestingMonths;
        this.growthTime = growthTime * (float)CalendarTFC.CALENDAR_TIME.getDaysInMonth() * 24.0f;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minRain = minRain;
        this.maxRain = maxRain;
    }

    public Food getFruit() {
        return this.fruit;
    }

    @Override
    public float getGrowthTime() {
        return this.growthTime;
    }

    @Override
    public boolean isFlowerMonth(Month month) {
        Month testing = this.flowerMonthStart;
        for (int i = 0; i < this.floweringMonths; ++i) {
            if (testing.equals((Object)month)) {
                return true;
            }
            testing = testing.next();
        }
        return false;
    }

    @Override
    public boolean isHarvestMonth(Month month) {
        Month testing = this.harvestMonthStart;
        for (int i = 0; i < this.harvestingMonths; ++i) {
            if (testing.equals((Object)month)) {
                return true;
            }
            testing = testing.next();
        }
        return false;
    }

    @Override
    public boolean isValidConditions(float temperature, float rainfall) {
        return this.minTemp - 5.0f < temperature && temperature < this.maxTemp + 5.0f && this.minRain - 50.0f < rainfall && rainfall < this.maxRain + 50.0f;
    }

    @Override
    public boolean isValidForGrowth(float temperature, float rainfall) {
        return this.minTemp < temperature && temperature < this.maxTemp && this.minRain < rainfall && rainfall < this.maxRain;
    }

    @Override
    public ItemStack getFoodDrop() {
        return new ItemStack((Item)ItemFoodTFC.get(this.getFruit()));
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tfc.tooltip.climate_info", (Object[])new Object[0]));
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.climate_info_rainfall", (Object[])new Object[]{(int)this.minRain, (int)this.maxRain}));
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tfc.tooltip.climate_info_temperature", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.minTemp)), String.format("%.1f", Float.valueOf(this.maxTemp))}));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tfc.tooltip.hold_shift_for_climate_info", (Object[])new Object[0]));
        }
    }

    static {
        for (FruitTree tree : FruitTree.values()) {
            WorldGenFruitTrees.register(tree);
        }
    }
}

