/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Multiblock
implements BiPredicate<World, BlockPos> {
    private final List<BiPredicate<World, BlockPos>> conditions = new ArrayList<BiPredicate<World, BlockPos>>();

    public Multiblock match(BlockPos posOffset, BiPredicate<World, BlockPos> condition) {
        this.conditions.add((world, pos) -> condition.test((World)world, pos.func_177971_a((Vec3i)posOffset)));
        return this;
    }

    public Multiblock match(BlockPos posOffset, Predicate<IBlockState> stateMatcher) {
        this.conditions.add((world, pos) -> stateMatcher.test(world.func_180495_p(pos.func_177971_a((Vec3i)posOffset))));
        return this;
    }

    public <T extends TileEntity> Multiblock match(BlockPos posOffset, Predicate<T> tileEntityPredicate, Class<T> teClass) {
        this.conditions.add((world, pos) -> {
            Object tile = Helpers.getTE((IBlockAccess)world, pos.func_177971_a((Vec3i)posOffset), teClass);
            if (tile != null) {
                return tileEntityPredicate.test(tile);
            }
            return false;
        });
        return this;
    }

    public Multiblock matchOneOf(BlockPos baseOffset, Multiblock subMultiblock) {
        this.conditions.add((world, pos) -> {
            for (BiPredicate<World, BlockPos> condition : subMultiblock.conditions) {
                if (!condition.test((World)world, pos.func_177971_a((Vec3i)baseOffset))) continue;
                return true;
            }
            return false;
        });
        return this;
    }

    @Override
    public boolean test(World world, BlockPos pos) {
        for (BiPredicate<World, BlockPos> condition : this.conditions) {
            if (condition.test(world, pos)) continue;
            return false;
        }
        return true;
    }
}

