/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class CalendarWorldData
extends WorldSavedData {
    private static final String NAME = "tfc_calendar";
    private static final String NAME_PRE_V1_5_0_X = "tfc:calendar";
    private static final Logger LOGGER = LogManager.getLogger();
    private final CalendarTFC calendar = new CalendarTFC();

    @Nonnull
    public static CalendarWorldData get(@Nonnull World world) {
        MapStorage mapStorage = world.func_175693_T();
        if (mapStorage != null) {
            CalendarWorldData data = (CalendarWorldData)mapStorage.func_75742_a(CalendarWorldData.class, NAME);
            if (data == null) {
                LOGGER.info("Creating default calendar world data.");
                data = new CalendarWorldData(NAME);
                data.func_76185_a();
                mapStorage.func_75745_a(NAME, (WorldSavedData)data);
                CalendarWorldData oldData = (CalendarWorldData)mapStorage.func_75742_a(CalendarWorldData.class, NAME_PRE_V1_5_0_X);
                if (oldData != null) {
                    LOGGER.info("Found v1.5.x save data, migrating it to new location.");
                    data.calendar.deserializeNBT(oldData.calendar.serializeNBT());
                }
            }
            return data;
        }
        throw new IllegalStateException("Unable to access calendar data - everything is wrong now");
    }

    public CalendarWorldData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.calendar.deserializeNBT(nbt.func_74775_l("calendar"));
    }

    @Nonnull
    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a("calendar", (NBTBase)CalendarTFC.INSTANCE.serializeNBT());
        return nbt;
    }

    public boolean func_76188_b() {
        return true;
    }

    @Nonnull
    public CalendarTFC getCalendar() {
        return this.calendar;
    }
}

