/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import javax.annotation.Nonnull;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.Month;

public interface ICalendarFormatted
extends ICalendar {
    public static long getTotalMonths(long time, long daysInMonth) {
        return time / (daysInMonth * 24000L);
    }

    public static long getTotalYears(long time, long daysInMonth) {
        return 1000L + time / (12L * daysInMonth * 24000L);
    }

    public static int getMinuteOfHour(long time) {
        return (int)((float)(time % 1000L) / 16.666666f);
    }

    public static int getHourOfDay(long time) {
        return (int)(time / 1000L % 24L);
    }

    public static int getDayOfMonth(long time, long daysInMonth) {
        return 1 + (int)(time / 24000L % daysInMonth);
    }

    public static String getTimeAndDate(long time, long daysInMonth) {
        return ICalendarFormatted.getTimeAndDate(ICalendarFormatted.getHourOfDay(time), ICalendarFormatted.getMinuteOfHour(time), ICalendarFormatted.getMonthOfYear(time, daysInMonth), ICalendarFormatted.getDayOfMonth(time, daysInMonth), ICalendarFormatted.getTotalYears(time, daysInMonth));
    }

    public static String getTimeAndDate(int hour, int minute, Month month, int day, long years) {
        String monthName = TerraFirmaCraft.getProxy().getMonthName(month, false);
        return TerraFirmaCraft.getProxy().getDate(hour, minute, monthName, day, years);
    }

    @Nonnull
    public static Month getMonthOfYear(long time, long daysInMonth) {
        return Month.valueOf((int)(time / (24000L * daysInMonth) % 12L));
    }

    @Override
    public long getTicks();

    public long getDaysInMonth();

    default public String getTimeAndDate() {
        return ICalendarFormatted.getTimeAndDate(this.getTicks(), this.getDaysInMonth());
    }

    default public String getSeasonDisplayName() {
        return TerraFirmaCraft.getProxy().getMonthName(this.getMonthOfYear(), true);
    }

    default public String getDisplayDayName() {
        return TerraFirmaCraft.getProxy().getDayName(this.getDayOfMonth(), this.getTotalDays());
    }

    default public long getTotalYears() {
        return ICalendarFormatted.getTotalYears(this.getTicks(), this.getDaysInMonth());
    }

    default public long getWorldTime() {
        return (this.getTicks() - 6000L) % 24000L;
    }

    default public long getTotalMonths() {
        return this.getTicks() / (this.getDaysInMonth() * 24000L);
    }

    default public Month getMonthOfYear() {
        return ICalendarFormatted.getMonthOfYear(this.getTicks(), this.getDaysInMonth());
    }

    default public int getDayOfMonth() {
        return ICalendarFormatted.getDayOfMonth(this.getTicks(), this.getDaysInMonth());
    }

    default public int getHourOfDay() {
        return ICalendarFormatted.getHourOfDay(this.getTicks());
    }

    default public int getMinuteOfHour() {
        return ICalendarFormatted.getMinuteOfHour(this.getTicks());
    }
}

