/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BiomeHelper {
    @Nullable
    public static BiomeType getBiomeType(float temperature, float rainfall, float density) {
        for (BiomeType biomeType : BiomeType.values()) {
            if (!biomeType.isValid(temperature, rainfall, density)) continue;
            return biomeType;
        }
        return null;
    }

    @Nonnull
    public static List<BiomeType> getValidBiomeTypes(float temperature, float rainfall, float density) {
        ArrayList<BiomeType> biomeTypes = new ArrayList<BiomeType>();
        for (BiomeType biomeType : BiomeType.values()) {
            if (!biomeType.isValid(temperature, rainfall, density)) continue;
            biomeTypes.add(biomeType);
        }
        return biomeTypes;
    }

    private BiomeHelper() {
    }

    public static enum BiomeType {
        TROPICAL_FOREST(19.0f, 100.0f, 60.0f, 500.0f, 0.25f, 1.0f),
        TEMPERATE_FOREST(-2.0f, 22.0f, 60.0f, 500.0f, 0.25f, 1.0f),
        TAIGA(-15.0f, 6.0f, 60.0f, 500.0f, 0.25f, 1.0f),
        PLAINS(0.0f, 22.0f, 60.0f, 500.0f, 0.0f, 0.25f),
        SAVANNA(19.0f, 100.0f, 60.0f, 500.0f, 0.0f, 0.3f),
        TUNDRA(-100.0f, 0.0f, 0.0f, 500.0f, 0.0f, 1.0f),
        DESERT(0.0f, 100.0f, 0.0f, 60.0f, 0.0f, 1.0f);

        private final float temperatureMin;
        private final float temperatureMax;
        private final float rainfallMin;
        private final float rainfallMax;
        private final float densityMin;
        private final float densityMax;

        private BiomeType(float temperatureMin, float temperatureMax, float rainfallMin, float rainfallMax, float densityMin, float densityMax) {
            this.temperatureMin = temperatureMin;
            this.temperatureMax = temperatureMax;
            this.rainfallMin = rainfallMin;
            this.rainfallMax = rainfallMax;
            this.densityMin = densityMin;
            this.densityMax = densityMax;
        }

        public boolean isValid(float temperature, float rainfall, float density) {
            return rainfall >= this.rainfallMin && rainfall <= this.rainfallMax && temperature >= this.temperatureMin && temperature <= this.temperatureMax && density >= this.densityMin && density <= this.densityMax;
        }
    }
}

