/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.forge;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.util.forge.ForgeStep;
import net.dries007.tfc.util.forge.ForgeSteps;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum ForgeRule {
    HIT_ANY(Order.ANY, ForgeStep.HIT_LIGHT),
    HIT_NOT_LAST(Order.NOT_LAST, ForgeStep.HIT_LIGHT),
    HIT_LAST(Order.LAST, ForgeStep.HIT_LIGHT),
    HIT_SECOND_LAST(Order.SECOND_LAST, ForgeStep.HIT_LIGHT),
    HIT_THIRD_LAST(Order.THIRD_LAST, ForgeStep.HIT_LIGHT),
    DRAW_ANY(Order.ANY, ForgeStep.DRAW),
    DRAW_LAST(Order.LAST, ForgeStep.DRAW),
    DRAW_NOT_LAST(Order.NOT_LAST, ForgeStep.DRAW),
    DRAW_SECOND_LAST(Order.SECOND_LAST, ForgeStep.DRAW),
    DRAW_THIRD_LAST(Order.THIRD_LAST, ForgeStep.DRAW),
    PUNCH_ANY(Order.ANY, ForgeStep.PUNCH),
    PUNCH_LAST(Order.LAST, ForgeStep.PUNCH),
    PUNCH_NOT_LAST(Order.NOT_LAST, ForgeStep.PUNCH),
    PUNCH_SECOND_LAST(Order.SECOND_LAST, ForgeStep.PUNCH),
    PUNCH_THIRD_LAST(Order.THIRD_LAST, ForgeStep.PUNCH),
    BEND_ANY(Order.ANY, ForgeStep.BEND),
    BEND_LAST(Order.LAST, ForgeStep.BEND),
    BEND_NOT_LAST(Order.NOT_LAST, ForgeStep.BEND),
    BEND_SECOND_LAST(Order.SECOND_LAST, ForgeStep.BEND),
    BEND_THIRD_LAST(Order.THIRD_LAST, ForgeStep.BEND),
    UPSET_ANY(Order.ANY, ForgeStep.UPSET),
    UPSET_LAST(Order.LAST, ForgeStep.UPSET),
    UPSET_NOT_LAST(Order.NOT_LAST, ForgeStep.UPSET),
    UPSET_SECOND_LAST(Order.SECOND_LAST, ForgeStep.UPSET),
    UPSET_THIRD_LAST(Order.THIRD_LAST, ForgeStep.UPSET),
    SHRINK_ANY(Order.ANY, ForgeStep.SHRINK),
    SHRINK_LAST(Order.LAST, ForgeStep.SHRINK),
    SHRINK_NOT_LAST(Order.NOT_LAST, ForgeStep.SHRINK),
    SHRINK_SECOND_LAST(Order.SECOND_LAST, ForgeStep.SHRINK),
    SHRINK_THIRD_LAST(Order.THIRD_LAST, ForgeStep.SHRINK);

    private static final ForgeRule[] VALUES;
    private final Order order;
    private final ForgeStep type;

    public static int getID(@Nullable ForgeRule rule) {
        return rule == null ? -1 : rule.ordinal();
    }

    @Nullable
    public static ForgeRule valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : null;
    }

    private ForgeRule(Order order, ForgeStep type) {
        this.order = order;
        this.type = type == ForgeStep.HIT_MEDIUM || type == ForgeStep.HIT_HARD ? ForgeStep.HIT_LIGHT : type;
    }

    @SideOnly(value=Side.CLIENT)
    public int getU() {
        return this.type == ForgeStep.HIT_LIGHT ? 218 : this.type.getU();
    }

    @SideOnly(value=Side.CLIENT)
    public int getV() {
        return this.type == ForgeStep.HIT_LIGHT ? 18 : this.type.getV();
    }

    @SideOnly(value=Side.CLIENT)
    public int getW() {
        return this.order.v;
    }

    public boolean matches(@Nonnull ForgeSteps steps) {
        switch (this.order) {
            case ANY: {
                return this.matchesStep(steps.getStep(2)) || this.matchesStep(steps.getStep(1)) || this.matchesStep(steps.getStep(0));
            }
            case NOT_LAST: {
                return this.matchesStep(steps.getStep(1)) || this.matchesStep(steps.getStep(0));
            }
            case LAST: {
                return this.matchesStep(steps.getStep(2));
            }
            case SECOND_LAST: {
                return this.matchesStep(steps.getStep(1));
            }
            case THIRD_LAST: {
                return this.matchesStep(steps.getStep(0));
            }
        }
        return false;
    }

    private boolean matchesStep(@Nullable ForgeStep step) {
        switch (this.type) {
            case HIT_LIGHT: {
                return step == ForgeStep.HIT_LIGHT || step == ForgeStep.HIT_MEDIUM || step == ForgeStep.HIT_HARD;
            }
        }
        return this.type == step;
    }

    static {
        VALUES = ForgeRule.values();
    }

    private static enum Order {
        ANY(88),
        LAST(0),
        NOT_LAST(66),
        SECOND_LAST(22),
        THIRD_LAST(44);

        private final int v;

        private Order(int v) {
            this.v = v;
        }
    }
}

